"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteSavedObject = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteSavedObject = type => {
  const kibana = (0, _public.useKibana)();
  const [error, setError] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [deletedId, setDeletedId] = (0, _react.useState)(null);
  const deleteObject = (0, _react.useCallback)(id => {
    setLoading(true);
    const dobj = async () => {
      try {
        var _kibana$services$save;
        await ((_kibana$services$save = kibana.services.savedObjects) === null || _kibana$services$save === void 0 ? void 0 : _kibana$services$save.client.delete(type, id));
        setError(null);
        setDeletedId(id);
        setLoading(false);
      } catch (e) {
        setLoading(false);
        setError(e);
      }
    };
    dobj();
  }, [type, kibana.services.savedObjects]);
  return {
    loading,
    error,
    deleteObject,
    deletedId
  };
};
exports.useDeleteSavedObject = useDeleteSavedObject;