"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _translations = require("../translations");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = (app, appTitle, extraCrumbs) => {
  const {
    services: {
      chrome
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const observabilityLinkProps = (0, _public.useLinkProps)({
    app: 'observability-overview'
  });
  const appLinkProps = (0, _public.useLinkProps)({
    app
  });
  (0, _react.useEffect)(() => {
    const breadcrumbs = [{
      ...observabilityLinkProps,
      text: _translations.observabilityTitle
    }, {
      ...appLinkProps,
      text: appTitle
    }, ...extraCrumbs];
    const docTitle = [...breadcrumbs].reverse().map(breadcrumb => breadcrumb.text);
    chrome.docTitle.change(docTitle);
    chrome.setBreadcrumbs(breadcrumbs);
  }, [appLinkProps, appTitle, chrome, extraCrumbs, observabilityLinkProps]);
};
exports.useBreadcrumbs = useBreadcrumbs;