"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsHistory = useAlertsHistory;
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/rule-registry-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAlertsHistory({
  featureIds,
  ruleId,
  dateRange
}) {
  const {
    http
  } = (0, _public.useKibana)().services;
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const [state, refetch] = (0, _useAsyncFn.default)(() => {
    abortCtrlRef.current.abort();
    abortCtrlRef.current = new AbortController();
    return fetchTriggeredAlertsHistory({
      featureIds,
      http,
      ruleId,
      dateRange,
      signal: abortCtrlRef.current.signal
    });
  }, [ruleId], {
    loading: true
  });
  (0, _react.useEffect)(() => {
    refetch();
  }, [refetch]);
  const {
    value,
    error,
    loading
  } = state;
  return {
    ...value,
    error,
    loading,
    refetch
  };
}
async function fetchTriggeredAlertsHistory({
  featureIds,
  http,
  ruleId,
  dateRange,
  signal
}) {
  return http.post(`${_common.BASE_RAC_ALERTS_API_PATH}/find`, {
    signal,
    body: JSON.stringify({
      size: 0,
      feature_ids: featureIds,
      query: {
        bool: {
          must: [{
            term: {
              [_ruleDataUtils.ALERT_RULE_UUID]: ruleId
            }
          }, {
            range: {
              [_ruleDataUtils.ALERT_TIME_RANGE]: dateRange
            }
          }]
        }
      },
      aggs: {
        histogramTriggeredAlerts: {
          date_histogram: {
            field: _ruleDataUtils.ALERT_START,
            fixed_interval: '1d',
            extended_bounds: {
              min: dateRange.from,
              max: dateRange.to
            }
          }
        },
        avgTimeToRecoverUS: {
          filter: {
            term: {
              [_ruleDataUtils.ALERT_STATUS]: 'recovered'
            }
          },
          aggs: {
            recoveryTime: {
              avg: {
                field: _ruleDataUtils.ALERT_DURATION
              }
            }
          }
        }
      }
    })
  }).then(extractAlertsHistory);
}
const extractAlertsHistory = response => {
  var _response$aggregation, _response$aggregation2;
  const totalTriggeredAlerts = response.hits.total.value || 0;
  const histogramAgg = response === null || response === void 0 ? void 0 : (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.histogramTriggeredAlerts;
  const histogramTriggeredAlerts = histogramAgg.buckets;
  const avgTimeToRecoverAgg = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.avgTimeToRecoverUS;
  const avgTimeToRecoverUS = avgTimeToRecoverAgg.value || 0;
  return {
    totalTriggeredAlerts,
    histogramTriggeredAlerts,
    avgTimeToRecoverUS
  };
};