"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedViewContext = exports.useSavedView = exports.SavedViewProvider = exports.SavedView = void 0;
var _constate = _interopRequireDefault(require("constate"));
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_url_state = require("../../utils/use_url_state");
var _use_find_saved_object = require("../../hooks/use_find_saved_object");
var _use_create_saved_object = require("../../hooks/use_create_saved_object");
var _use_delete_saved_object = require("../../hooks/use_delete_saved_object");
var _metrics_source = require("../metrics_source");
var _source_configuration_form_state = require("../../pages/metrics/settings/source_configuration_form_state");
var _use_get_saved_object = require("../../hooks/use_get_saved_object");
var _use_update_saved_object = require("../../hooks/use_update_saved_object");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savedViewUrlStateRT = rt.type({
  viewId: rt.string
});
const DEFAULT_SAVED_VIEW_STATE = {
  viewId: '0'
};
const useSavedView = props => {
  const {
    source,
    isLoading: sourceIsLoading,
    sourceExists,
    createSourceConfiguration,
    updateSourceConfiguration
  } = (0, _metrics_source.useSourceContext)();
  const {
    viewType,
    defaultViewState
  } = props;
  const {
    data,
    loading,
    find,
    error: errorOnFind,
    hasView
  } = (0, _use_find_saved_object.useFindSavedObject)(viewType);
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: DEFAULT_SAVED_VIEW_STATE,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: 'savedView'
  });
  const [shouldLoadDefault] = (0, _react.useState)(props.shouldLoadDefault);
  const [currentView, setCurrentView] = (0, _react.useState)(null);
  const [loadingDefaultView, setLoadingDefaultView] = (0, _react.useState)(null);
  const {
    create,
    error: errorOnCreate,
    data: createdViewData,
    createdId
  } = (0, _use_create_saved_object.useCreateSavedObject)(viewType);
  const {
    update,
    error: errorOnUpdate,
    data: updatedViewData,
    updatedId
  } = (0, _use_update_saved_object.useUpdateSavedObject)(viewType);
  const {
    deleteObject,
    deletedId
  } = (0, _use_delete_saved_object.useDeleteSavedObject)(viewType);
  const {
    getObject,
    data: currentViewSavedObject
  } = (0, _use_get_saved_object.useGetSavedObject)(viewType);
  const [createError, setCreateError] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => setCreateError(errorOnCreate), [errorOnCreate]);
  const deleteView = (0, _react.useCallback)(id => deleteObject(id), [deleteObject]);
  const formState = (0, _source_configuration_form_state.useSourceConfigurationFormState)(source && source.configuration);
  const defaultViewFieldName = (0, _react.useMemo)(() => viewType === 'inventory-view' ? 'inventoryDefaultView' : 'metricsExplorerDefaultView', [viewType]);
  const makeDefault = (0, _react.useCallback)(async id => {
    if (sourceExists) {
      await updateSourceConfiguration({
        ...formState.formStateChanges,
        [defaultViewFieldName]: id
      });
    } else {
      await createSourceConfiguration({
        ...formState.formState,
        [defaultViewFieldName]: id
      });
    }
  }, [formState.formState, formState.formStateChanges, sourceExists, defaultViewFieldName, createSourceConfiguration, updateSourceConfiguration]);
  const saveView = (0, _react.useCallback)(d => {
    const doSave = async () => {
      const exists = await hasView(d.name);
      if (exists) {
        setCreateError(_i18n.i18n.translate('xpack.infra.savedView.errorOnCreate.duplicateViewName', {
          defaultMessage: `A view with that name already exists.`
        }));
        return;
      }
      create(d);
    };
    setCreateError(null);
    doSave();
  }, [create, hasView]);
  const updateView = (0, _react.useCallback)((id, d) => {
    const doSave = async () => {
      const view = await hasView(d.name);
      if (view && view.id !== id) {
        setCreateError(_i18n.i18n.translate('xpack.infra.savedView.errorOnCreate.duplicateViewName', {
          defaultMessage: `A view with that name already exists.`
        }));
        return;
      }
      update(id, d);
    };
    setCreateError(null);
    doSave();
  }, [update, hasView]);
  const defaultViewId = (0, _react.useMemo)(() => {
    if (!source || !source.configuration) {
      return '';
    }
    if (defaultViewFieldName === 'inventoryDefaultView') {
      return source.configuration.inventoryDefaultView;
    } else if (defaultViewFieldName === 'metricsExplorerDefaultView') {
      return source.configuration.metricsExplorerDefaultView;
    } else {
      return '';
    }
  }, [source, defaultViewFieldName]);
  const mapToView = (0, _react.useCallback)(o => {
    return {
      ...o.attributes,
      id: o.id,
      isDefault: defaultViewId === o.id
    };
  }, [defaultViewId]);
  const savedObjects = (0, _react.useMemo)(() => data ? data.savedObjects : [], [data]);
  const views = (0, _react.useMemo)(() => {
    const items = [{
      name: _i18n.i18n.translate('xpack.infra.savedView.defaultViewNameHosts', {
        defaultMessage: 'Default view'
      }),
      id: '0',
      isDefault: !defaultViewId || defaultViewId === '0',
      // If there is no default view then hosts is the default
      ...defaultViewState
    }];
    savedObjects.forEach(o => o.type === viewType && items.push(mapToView(o)));
    return items;
  }, [defaultViewState, savedObjects, viewType, defaultViewId, mapToView]);
  const createdView = (0, _react.useMemo)(() => {
    return createdViewData ? mapToView(createdViewData) : null;
  }, [createdViewData, mapToView]);
  const updatedView = (0, _react.useMemo)(() => {
    return updatedViewData ? mapToView(updatedViewData) : null;
  }, [updatedViewData, mapToView]);
  const loadDefaultView = (0, _react.useCallback)(() => {
    setLoadingDefaultView(true);
    getObject(defaultViewId);
  }, [setLoadingDefaultView, getObject, defaultViewId]);
  (0, _react.useEffect)(() => {
    if (currentViewSavedObject) {
      setCurrentView(mapToView(currentViewSavedObject));
      setLoadingDefaultView(false);
    }
  }, [currentViewSavedObject, defaultViewId, mapToView]);
  const setDefault = (0, _react.useCallback)(() => {
    setCurrentView({
      name: _i18n.i18n.translate('xpack.infra.savedView.defaultViewNameHosts', {
        defaultMessage: 'Default view'
      }),
      id: '0',
      isDefault: !defaultViewId || defaultViewId === '0',
      // If there is no default view then hosts is the default
      ...defaultViewState
    });
  }, [setCurrentView, defaultViewId, defaultViewState]);
  const loadDefaultViewIfSet = (0, _react.useCallback)(() => {
    if (defaultViewId !== '0') {
      loadDefaultView();
    } else {
      setDefault();
      setLoadingDefaultView(false);
    }
  }, [defaultViewId, loadDefaultView, setDefault, setLoadingDefaultView]);
  (0, _react.useEffect)(() => {
    if (loadingDefaultView || currentView || !shouldLoadDefault) {
      return;
    }
    loadDefaultViewIfSet();
  }, [loadDefaultViewIfSet, loadingDefaultView, currentView, shouldLoadDefault]);
  (0, _react.useEffect)(() => {
    if (currentView && urlState.viewId !== currentView.id && data) setUrlState({
      viewId: currentView.id
    });
  }, [urlState, setUrlState, currentView, defaultViewId, data]);
  (0, _react.useEffect)(() => {
    if (!currentView && !loading && data && shouldLoadDefault) {
      const viewToSet = views.find(v => v.id === urlState.viewId);
      if (viewToSet) setCurrentView(viewToSet);else loadDefaultViewIfSet();
    }
  }, [loading, currentView, data, views, setCurrentView, loadDefaultViewIfSet, urlState.viewId, shouldLoadDefault]);
  return {
    views,
    saveView,
    defaultViewId,
    loading,
    updateView,
    updatedView,
    updatedId,
    deletedId,
    createdId,
    createdView,
    errorOnUpdate,
    errorOnFind,
    errorOnCreate: createError,
    shouldLoadDefault,
    makeDefault,
    sourceIsLoading,
    deleteView,
    loadingDefaultView,
    setCurrentView,
    currentView,
    loadDefaultView,
    find
  };
};
exports.useSavedView = useSavedView;
const SavedView = (0, _constate.default)(useSavedView);
exports.SavedView = SavedView;
const [SavedViewProvider, useSavedViewContext] = SavedView;
exports.useSavedViewContext = useSavedViewContext;
exports.SavedViewProvider = SavedViewProvider;
const encodeUrlState = state => {
  return savedViewUrlStateRT.encode(state);
};
const decodeUrlState = value => {
  const state = (0, _pipeable.pipe)(savedViewUrlStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
  return state;
};