"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callSetupMlModuleAPI = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _infra_ml = require("../../../../common/infra_ml");
var _runtime_types = require("../../../../common/runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callSetupMlModuleAPI = async (requestArgs, fetch) => {
  const {
    moduleId,
    start,
    end,
    spaceId,
    sourceId,
    indexPattern,
    jobOverrides = [],
    datafeedOverrides = [],
    query
  } = requestArgs;
  const response = await fetch(`/api/ml/modules/setup/${moduleId}`, {
    method: 'POST',
    body: JSON.stringify(setupMlModuleRequestPayloadRT.encode({
      start,
      end,
      indexPatternName: indexPattern,
      prefix: (0, _infra_ml.getJobIdPrefix)(spaceId, sourceId),
      startDatafeed: true,
      jobOverrides,
      datafeedOverrides,
      query
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(setupMlModuleResponsePayloadRT)(response);
};
exports.callSetupMlModuleAPI = callSetupMlModuleAPI;
const setupMlModuleTimeParamsRT = rt.partial({
  start: rt.number,
  end: rt.number
});
const setupMlModuleJobOverridesRT = rt.type({
  job_id: rt.string,
  custom_settings: _infra_ml.jobCustomSettingsRT
});
const setupMlModuleDatafeedOverridesRT = rt.object;
const setupMlModuleRequestParamsRT = rt.intersection([rt.strict({
  indexPatternName: rt.string,
  prefix: rt.string,
  startDatafeed: rt.boolean,
  jobOverrides: rt.array(setupMlModuleJobOverridesRT),
  datafeedOverrides: rt.array(setupMlModuleDatafeedOverridesRT)
}), rt.exact(rt.partial({
  query: rt.object
}))]);
const setupMlModuleRequestPayloadRT = rt.intersection([setupMlModuleTimeParamsRT, setupMlModuleRequestParamsRT]);
const setupErrorResponseRT = rt.type({
  msg: rt.string
});
const datafeedSetupResponseRT = rt.intersection([rt.type({
  id: rt.string,
  started: rt.boolean,
  success: rt.boolean
}), rt.partial({
  error: setupErrorResponseRT
})]);
const jobSetupResponseRT = rt.intersection([rt.type({
  id: rt.string,
  success: rt.boolean
}), rt.partial({
  error: setupErrorResponseRT
})]);
const setupMlModuleResponsePayloadRT = rt.type({
  datafeeds: rt.array(datafeedSetupResponseRT),
  jobs: rt.array(jobSetupResponseRT)
});