"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobSummaryRT = exports.fetchJobStatusResponsePayloadRT = exports.fetchJobStatusRequestPayloadRT = exports.callJobsSummaryAPI = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _infra_ml = require("../../../../common/infra_ml");
var _runtime_types = require("../../../../common/runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callJobsSummaryAPI = async (requestArgs, fetch) => {
  const {
    spaceId,
    sourceId,
    jobTypes
  } = requestArgs;
  const response = await fetch('/api/ml/jobs/jobs_summary', {
    method: 'POST',
    body: JSON.stringify(fetchJobStatusRequestPayloadRT.encode({
      jobIds: jobTypes.map(jobType => (0, _infra_ml.getJobId)(spaceId, sourceId, jobType))
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(fetchJobStatusResponsePayloadRT)(response);
};
exports.callJobsSummaryAPI = callJobsSummaryAPI;
const fetchJobStatusRequestPayloadRT = rt.type({
  jobIds: rt.array(rt.string)
});
exports.fetchJobStatusRequestPayloadRT = fetchJobStatusRequestPayloadRT;
const datafeedStateRT = rt.keyof({
  started: null,
  starting: null,
  stopped: null,
  stopping: null,
  '': null
});

// this is the union of the ML API's job state and block reasons
const jobStateRT = rt.keyof({
  closed: null,
  closing: null,
  deleting: null,
  failed: null,
  opened: null,
  opening: null,
  resetting: null,
  reverting: null
});
const jobCategorizationStatusRT = rt.keyof({
  ok: null,
  warn: null
});
const jobModelSizeStatsRT = rt.type({
  categorization_status: jobCategorizationStatusRT,
  categorized_doc_count: rt.number,
  dead_category_count: rt.number,
  frequent_category_count: rt.number,
  rare_category_count: rt.number,
  total_category_count: rt.number
});
const jobSummaryRT = rt.intersection([rt.type({
  id: rt.string,
  jobState: jobStateRT
}), rt.partial({
  awaitingNodeAssignment: rt.boolean,
  datafeedIndices: rt.array(rt.string),
  datafeedState: datafeedStateRT,
  fullJob: rt.partial({
    custom_settings: _infra_ml.jobCustomSettingsRT,
    finished_time: rt.number,
    model_size_stats: jobModelSizeStatsRT
  })
})]);
exports.jobSummaryRT = jobSummaryRT;
const fetchJobStatusResponsePayloadRT = rt.array(jobSummaryRT);
exports.fetchJobStatusResponsePayloadRT = fetchJobStatusResponsePayloadRT;