"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntriesBeforeResponse = exports.useLogEntriesBeforeRequest = exports.useFetchLogEntriesBefore = exports.parseLogEntriesBeforeSearchResponses = void 0;
var _react = require("react");
var _operators = require("rxjs/operators");
var _runtime_types = require("../../../../common/runtime_types");
var _log_entries = require("../../../../common/search_strategies/log_entries/log_entries");
var _data_search = require("../../../utils/data_search");
var _use_observable = require("../../../utils/use_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntriesBeforeRequest = ({
  columnOverrides,
  endTimestamp,
  highlightPhrase,
  query,
  logViewReference,
  startTimestamp
}) => {
  const {
    search: fetchLogEntriesBefore,
    requests$: logEntriesBeforeSearchRequests$
  } = (0, _data_search.useDataSearch)({
    getRequest: (0, _react.useCallback)((cursor, params) => {
      var _params$extendTo;
      return !!logViewReference ? {
        request: {
          params: _log_entries.logEntriesSearchRequestParamsRT.encode({
            before: cursor,
            columns: columnOverrides,
            endTimestamp,
            highlightPhrase,
            query: query,
            size: params.size,
            logView: logViewReference,
            startTimestamp: (_params$extendTo = params.extendTo) !== null && _params$extendTo !== void 0 ? _params$extendTo : startTimestamp
          })
        },
        options: {
          strategy: _log_entries.LOG_ENTRIES_SEARCH_STRATEGY
        }
      } : null;
    }, [columnOverrides, endTimestamp, highlightPhrase, query, logViewReference, startTimestamp]),
    parseResponses: parseLogEntriesBeforeSearchResponses
  });
  return {
    fetchLogEntriesBefore,
    logEntriesBeforeSearchRequests$
  };
};
exports.useLogEntriesBeforeRequest = useLogEntriesBeforeRequest;
const useLogEntriesBeforeResponse = logEntriesBeforeSearchRequests$ => {
  const logEntriesBeforeSearchResponse$ = (0, _use_observable.useOperator)(logEntriesBeforeSearchRequests$, flattenLogEntriesBeforeSearchResponse);
  const {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    loaded,
    total
  } = (0, _data_search.useDataSearchResponseState)(logEntriesBeforeSearchResponse$);
  return {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    loaded,
    logEntriesBeforeSearchRequests$,
    logEntriesBeforeSearchResponse$,
    total
  };
};
exports.useLogEntriesBeforeResponse = useLogEntriesBeforeResponse;
const useFetchLogEntriesBefore = ({
  columnOverrides,
  endTimestamp,
  highlightPhrase,
  query,
  logViewReference,
  startTimestamp
}) => {
  const {
    fetchLogEntriesBefore,
    logEntriesBeforeSearchRequests$
  } = useLogEntriesBeforeRequest({
    columnOverrides,
    endTimestamp,
    highlightPhrase,
    query,
    logViewReference,
    startTimestamp
  });
  const {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    loaded,
    logEntriesBeforeSearchResponse$,
    total
  } = useLogEntriesBeforeResponse(logEntriesBeforeSearchRequests$);
  return {
    cancelRequest,
    fetchLogEntriesBefore,
    isRequestRunning,
    isResponsePartial,
    loaded,
    logEntriesBeforeSearchResponse$,
    total
  };
};
exports.useFetchLogEntriesBefore = useFetchLogEntriesBefore;
const parseLogEntriesBeforeSearchResponses = (0, _data_search.normalizeDataSearchResponses)(null, (0, _runtime_types.decodeOrThrow)(_log_entries.logEntriesSearchResponsePayloadRT));
exports.parseLogEntriesBeforeSearchResponses = parseLogEntriesBeforeSearchResponses;
const flattenLogEntriesBeforeSearchResponse = (0, _operators.exhaustMap)(_data_search.flattenDataSearchResponseDescriptor);