"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNextAndPrevious = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _log_entry = require("../../../utils/log_entry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNextAndPrevious = ({
  highlightTerms,
  jumpToTargetPosition,
  logEntryHighlights,
  visibleMidpoint
}) => {
  const [currentTimeKey, setCurrentTimeKey] = (0, _react.useState)(null);
  const entries = (0, _react.useMemo)(
  // simplification, because we only support one highlight phrase for now
  () => logEntryHighlights && logEntryHighlights.length > 0 ? logEntryHighlights[0].entries : [], [logEntryHighlights]);
  (0, _react.useEffect)(() => {
    setCurrentTimeKey(null);
  }, [highlightTerms]);
  (0, _react.useEffect)(() => {
    if (currentTimeKey) {
      jumpToTargetPosition(currentTimeKey);
    }
  }, [currentTimeKey, jumpToTargetPosition]);
  (0, _react.useEffect)(() => {
    if (currentTimeKey === null && entries.length > 0) {
      const initialIndex = visibleMidpoint ? clampValue((0, _log_entry.getLogEntryIndexBeforeTime)(entries, visibleMidpoint), 0, entries.length - 1) : 0;
      const initialTimeKey = (0, _log_entry.getUniqueLogEntryKey)(entries[initialIndex]);
      setCurrentTimeKey(initialTimeKey);
    }
  }, [currentTimeKey, entries, setCurrentTimeKey, visibleMidpoint]);
  const indexOfCurrentTimeKey = (0, _react.useMemo)(() => {
    if (currentTimeKey && entries.length > 0) {
      return (0, _log_entry.getLogEntryIndexAtTime)(entries, currentTimeKey);
    } else {
      return null;
    }
  }, [currentTimeKey, entries]);
  const hasPreviousHighlight = (0, _react.useMemo)(() => (0, _lodash.isNumber)(indexOfCurrentTimeKey) && indexOfCurrentTimeKey > 0, [indexOfCurrentTimeKey]);
  const hasNextHighlight = (0, _react.useMemo)(() => entries.length > 0 && (0, _lodash.isNumber)(indexOfCurrentTimeKey) && indexOfCurrentTimeKey < entries.length - 1, [indexOfCurrentTimeKey, entries]);
  const goToPreviousHighlight = (0, _react.useCallback)(() => {
    if (entries.length && (0, _lodash.isNumber)(indexOfCurrentTimeKey)) {
      const previousIndex = indexOfCurrentTimeKey - 1;
      const entryTimeKey = (0, _log_entry.getUniqueLogEntryKey)(entries[previousIndex]);
      setCurrentTimeKey(entryTimeKey);
    }
  }, [indexOfCurrentTimeKey, entries]);
  const goToNextHighlight = (0, _react.useCallback)(() => {
    if (entries.length > 0 && (0, _lodash.isNumber)(indexOfCurrentTimeKey)) {
      const nextIndex = indexOfCurrentTimeKey + 1;
      const entryTimeKey = (0, _log_entry.getUniqueLogEntryKey)(entries[nextIndex]);
      setCurrentTimeKey(entryTimeKey);
    }
  }, [indexOfCurrentTimeKey, entries]);
  return {
    currentHighlightKey: currentTimeKey,
    hasPreviousHighlight,
    hasNextHighlight,
    goToPreviousHighlight,
    goToNextHighlight
  };
};
exports.useNextAndPrevious = useNextAndPrevious;
const clampValue = (value, minValue, maxValue) => Math.min(Math.max(value, minValue), maxValue);