"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchLogEntriesHighlights = void 0;
var _runtime_types = require("../../../../../common/runtime_types");
var _http_api = require("../../../../../common/http_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchLogEntriesHighlights = async (requestArgs, fetch) => {
  const response = await fetch(_http_api.LOG_ENTRIES_HIGHLIGHTS_PATH, {
    method: 'POST',
    body: JSON.stringify(_http_api.logEntriesHighlightsRequestRT.encode(requestArgs))
  });
  return (0, _runtime_types.decodeOrThrow)(_http_api.logEntriesHighlightsResponseRT)(response);
};
exports.fetchLogEntriesHighlights = fetchLogEntriesHighlights;