"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogFlyout = exports.useLogEntryFlyoutContext = exports.WithFlyoutOptionsUrlState = exports.LogFlyout = exports.LogEntryFlyoutProvider = exports.FlyoutVisibility = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _url_state = require("../../utils/url_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let FlyoutVisibility;
exports.FlyoutVisibility = FlyoutVisibility;
(function (FlyoutVisibility) {
  FlyoutVisibility["hidden"] = "hidden";
  FlyoutVisibility["visible"] = "visible";
})(FlyoutVisibility || (exports.FlyoutVisibility = FlyoutVisibility = {}));
const useLogFlyout = () => {
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const [logEntryId, setLogEntryId] = (0, _react.useState)(null);
  const [surroundingLogsId, setSurroundingLogsId] = (0, _react.useState)(null);
  const closeFlyout = (0, _react.useCallback)(() => setIsFlyoutOpen(false), []);
  const openFlyout = (0, _react.useCallback)(newLogEntryId => {
    if (newLogEntryId) {
      setLogEntryId(newLogEntryId);
    }
    setIsFlyoutOpen(true);
  }, []);
  return {
    isFlyoutOpen,
    closeFlyout,
    openFlyout,
    logEntryId,
    setLogEntryId,
    surroundingLogsId,
    setSurroundingLogsId
  };
};
exports.useLogFlyout = useLogFlyout;
const LogFlyout = (0, _constate.default)(useLogFlyout);
exports.LogFlyout = LogFlyout;
const [LogEntryFlyoutProvider, useLogEntryFlyoutContext] = LogFlyout;
exports.useLogEntryFlyoutContext = useLogEntryFlyoutContext;
exports.LogEntryFlyoutProvider = LogEntryFlyoutProvider;
const WithFlyoutOptionsUrlState = () => {
  const {
    isFlyoutOpen,
    openFlyout,
    closeFlyout,
    logEntryId,
    setLogEntryId,
    surroundingLogsId,
    setSurroundingLogsId
  } = useLogEntryFlyoutContext();
  return /*#__PURE__*/_react.default.createElement(_url_state.UrlStateContainer, {
    urlState: {
      flyoutVisibility: isFlyoutOpen ? FlyoutVisibility.visible : FlyoutVisibility.hidden,
      flyoutId: logEntryId,
      surroundingLogsId
    },
    urlStateKey: "flyoutOptions",
    mapToUrlState: mapToUrlState,
    onChange: newUrlState => {
      if (newUrlState && newUrlState.flyoutId) {
        setLogEntryId(newUrlState.flyoutId);
      }
      if (newUrlState && newUrlState.surroundingLogsId) {
        setSurroundingLogsId(newUrlState.surroundingLogsId);
      }
      if (newUrlState && newUrlState.flyoutVisibility === FlyoutVisibility.visible) {
        openFlyout();
      }
      if (newUrlState && newUrlState.flyoutVisibility === FlyoutVisibility.hidden) {
        closeFlyout();
      }
    },
    onInitialize: initialUrlState => {
      if (initialUrlState && initialUrlState.flyoutId) {
        setLogEntryId(initialUrlState.flyoutId);
      }
      if (initialUrlState && initialUrlState.surroundingLogsId) {
        setSurroundingLogsId(initialUrlState.surroundingLogsId);
      }
      if (initialUrlState && initialUrlState.flyoutVisibility === FlyoutVisibility.visible) {
        openFlyout();
      }
      if (initialUrlState && initialUrlState.flyoutVisibility === FlyoutVisibility.hidden) {
        closeFlyout();
      }
    }
  });
};
exports.WithFlyoutOptionsUrlState = WithFlyoutOptionsUrlState;
const mapToUrlState = value => value ? {
  flyoutId: mapToFlyoutIdState(value.flyoutId),
  flyoutVisibility: mapToFlyoutVisibilityState(value.flyoutVisibility),
  surroundingLogsId: mapToSurroundingLogsIdState(value.surroundingLogsId)
} : undefined;
const mapToFlyoutIdState = subject => {
  return subject && (0, _lodash.isString)(subject) ? subject : undefined;
};
const mapToSurroundingLogsIdState = subject => {
  return subject && (0, _lodash.isString)(subject) ? subject : undefined;
};
const mapToFlyoutVisibilityState = subject => {
  if (subject) {
    if (subject === 'visible') {
      return FlyoutVisibility.visible;
    }
    if (subject === 'hidden') {
      return FlyoutVisibility.hidden;
    }
  }
};