"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogAnalysisModuleDefinition = void 0;
var _react = require("react");
var _log_analysis = require("../../../../common/log_analysis");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_tracked_promise = require("../../../utils/use_tracked_promise");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogAnalysisModuleDefinition = ({
  sourceConfiguration: {
    spaceId,
    sourceId
  },
  moduleDescriptor
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [moduleDefinition, setModuleDefinition] = (0, _react.useState)();
  const jobDefinitionByJobId = (0, _react.useMemo)(() => moduleDefinition ? moduleDefinition.jobs.reduce((accumulatedJobDefinitions, jobDefinition) => ({
    ...accumulatedJobDefinitions,
    [(0, _log_analysis.getJobId)(spaceId, sourceId, jobDefinition.id)]: jobDefinition
  }), {}) : {}, [moduleDefinition, sourceId, spaceId]);
  const [fetchModuleDefinitionRequest, fetchModuleDefinition] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      return await moduleDescriptor.getModuleDefinition(services.http.fetch);
    },
    onResolve: response => {
      setModuleDefinition(response);
    },
    onReject: () => {
      setModuleDefinition(undefined);
    }
  }, [moduleDescriptor.getModuleDefinition, spaceId, sourceId]);
  const getIsJobDefinitionOutdated = (0, _react.useCallback)(jobSummary => {
    var _jobSummary$fullJob$c, _jobSummary$fullJob, _jobSummary$fullJob$c2;
    const jobDefinition = jobDefinitionByJobId[jobSummary.id];
    if (jobDefinition == null) {
      return false;
    }
    const currentRevision = jobDefinition === null || jobDefinition === void 0 ? void 0 : jobDefinition.config.custom_settings.job_revision;
    return ((_jobSummary$fullJob$c = (_jobSummary$fullJob = jobSummary.fullJob) === null || _jobSummary$fullJob === void 0 ? void 0 : (_jobSummary$fullJob$c2 = _jobSummary$fullJob.custom_settings) === null || _jobSummary$fullJob$c2 === void 0 ? void 0 : _jobSummary$fullJob$c2.job_revision) !== null && _jobSummary$fullJob$c !== void 0 ? _jobSummary$fullJob$c : 0) < (currentRevision !== null && currentRevision !== void 0 ? currentRevision : 0);
  }, [jobDefinitionByJobId]);
  return {
    fetchModuleDefinition,
    fetchModuleDefinitionRequestState: fetchModuleDefinitionRequest.state,
    getIsJobDefinitionOutdated,
    jobDefinitionByJobId,
    moduleDefinition
  };
};
exports.useLogAnalysisModuleDefinition = useLogAnalysisModuleDefinition;