"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogAnalysisCapabilitiesContext = exports.useLogAnalysisCapabilities = exports.LogAnalysisCapabilitiesProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _use_tracked_promise = require("../../../utils/use_tracked_promise");
var _ml_api_types = require("./api/ml_api_types");
var _runtime_types = require("../../../../common/runtime_types");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogAnalysisCapabilities = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [mlCapabilities, setMlCapabilities] = (0, _react.useState)(initialMlCapabilities);
  const [fetchMlCapabilitiesRequest, fetchMlCapabilities] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      const rawResponse = await services.http.fetch('/api/ml/ml_capabilities');
      return (0, _runtime_types.decodeOrThrow)(_ml_api_types.getMlCapabilitiesResponsePayloadRT)(rawResponse);
    },
    onResolve: response => {
      setMlCapabilities(response);
    }
  }, []);
  (0, _react.useEffect)(() => {
    fetchMlCapabilities();
  }, [fetchMlCapabilities]);
  const isLoading = (0, _react.useMemo)(() => fetchMlCapabilitiesRequest.state === 'pending', [fetchMlCapabilitiesRequest.state]);
  const hasLogAnalysisSetupCapabilities = mlCapabilities.capabilities.canCreateJob;
  const hasLogAnalysisReadCapabilities = mlCapabilities.capabilities.canGetJobs;
  const hasLogAnalysisCapabilites = mlCapabilities.isPlatinumOrTrialLicense && mlCapabilities.mlFeatureEnabledInSpace;
  return {
    hasLogAnalysisCapabilites,
    hasLogAnalysisReadCapabilities,
    hasLogAnalysisSetupCapabilities,
    isLoading
  };
};
exports.useLogAnalysisCapabilities = useLogAnalysisCapabilities;
const [LogAnalysisCapabilitiesProvider, useLogAnalysisCapabilitiesContext] = (0, _constate.default)(useLogAnalysisCapabilities);
exports.useLogAnalysisCapabilitiesContext = useLogAnalysisCapabilitiesContext;
exports.LogAnalysisCapabilitiesProvider = LogAnalysisCapabilitiesProvider;
const initialMlCapabilities = {
  capabilities: {
    canGetJobs: false,
    canCreateJob: false,
    canDeleteJob: false,
    canOpenJob: false,
    canCloseJob: false,
    canForecastJob: false,
    canGetDatafeeds: false,
    canStartStopDatafeed: false,
    canUpdateJob: false,
    canUpdateDatafeed: false,
    canPreviewDatafeed: false,
    canGetCalendars: false,
    canCreateCalendar: false,
    canDeleteCalendar: false,
    canGetFilters: false,
    canCreateFilter: false,
    canDeleteFilter: false,
    canFindFileStructure: false,
    canGetDataFrameJobs: false,
    canDeleteDataFrameJob: false,
    canPreviewDataFrameJob: false,
    canCreateDataFrameJob: false,
    canStartStopDataFrameJob: false
  },
  isPlatinumOrTrialLicense: false,
  mlFeatureEnabledInSpace: false,
  upgradeInProgress: false
};