"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopDatafeedsResponsePayloadRT = exports.stopDatafeedsRequestPayloadRT = exports.getJobDeletionTasksResponsePayloadRT = exports.deleteJobsResponsePayloadRT = exports.deleteJobsRequestPayloadRT = exports.callStopDatafeeds = exports.callGetJobDeletionTasks = exports.callDeleteJobs = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _log_analysis = require("../../../../../common/log_analysis");
var _runtime_types = require("../../../../../common/runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callDeleteJobs = async (requestArgs, fetch) => {
  const {
    spaceId,
    logViewId,
    jobTypes
  } = requestArgs;

  // NOTE: Deleting the jobs via this API will delete the datafeeds at the same time
  const deleteJobsResponse = await fetch('/api/ml/jobs/delete_jobs', {
    method: 'POST',
    body: JSON.stringify(deleteJobsRequestPayloadRT.encode({
      jobIds: jobTypes.map(jobType => (0, _log_analysis.getJobId)(spaceId, logViewId, jobType))
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(deleteJobsResponsePayloadRT)(deleteJobsResponse);
};
exports.callDeleteJobs = callDeleteJobs;
const callGetJobDeletionTasks = async fetch => {
  const jobDeletionTasksResponse = await fetch('/api/ml/jobs/deleting_jobs_tasks');
  return (0, _runtime_types.decodeOrThrow)(getJobDeletionTasksResponsePayloadRT)(jobDeletionTasksResponse);
};
exports.callGetJobDeletionTasks = callGetJobDeletionTasks;
const callStopDatafeeds = async (requestArgs, fetch) => {
  const {
    spaceId,
    logViewId,
    jobTypes
  } = requestArgs;

  // Stop datafeed due to https://github.com/elastic/kibana/issues/44652
  const stopDatafeedResponse = await fetch('/api/ml/jobs/stop_datafeeds', {
    method: 'POST',
    body: JSON.stringify(stopDatafeedsRequestPayloadRT.encode({
      datafeedIds: jobTypes.map(jobType => (0, _log_analysis.getDatafeedId)(spaceId, logViewId, jobType))
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(stopDatafeedsResponsePayloadRT)(stopDatafeedResponse);
};
exports.callStopDatafeeds = callStopDatafeeds;
const deleteJobsRequestPayloadRT = rt.type({
  jobIds: rt.array(rt.string)
});
exports.deleteJobsRequestPayloadRT = deleteJobsRequestPayloadRT;
const deleteJobsResponsePayloadRT = rt.record(rt.string, rt.type({
  deleted: rt.boolean
}));
exports.deleteJobsResponsePayloadRT = deleteJobsResponsePayloadRT;
const getJobDeletionTasksResponsePayloadRT = rt.type({
  jobIds: rt.array(rt.string)
});
exports.getJobDeletionTasksResponsePayloadRT = getJobDeletionTasksResponsePayloadRT;
const stopDatafeedsRequestPayloadRT = rt.type({
  datafeedIds: rt.array(rt.string)
});
exports.stopDatafeedsRequestPayloadRT = stopDatafeedsRequestPayloadRT;
const stopDatafeedsResponsePayloadRT = rt.record(rt.string, rt.type({
  stopped: rt.boolean
}));
exports.stopDatafeedsResponsePayloadRT = stopDatafeedsResponsePayloadRT;