"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedViewListModal = SavedViewListModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SavedViewListModal({
  onClose,
  views,
  setView,
  currentView
}) {
  const [options, setOptions] = (0, _react.useState)(null);
  const onChange = (0, _react.useCallback)(opts => {
    setOptions(opts);
  }, []);
  const loadView = (0, _react.useCallback)(() => {
    if (!options) {
      onClose();
      return;
    }
    const selected = options.find(o => o.checked);
    if (!selected) {
      onClose();
      return;
    }
    setView(views.find(v => v.id === selected.key));
    onClose();
  }, [options, views, setView, onClose]);
  const defaultOptions = (0, _react.useMemo)(() => {
    return views.map(v => ({
      label: v.name,
      key: v.id,
      checked: (currentView === null || currentView === void 0 ? void 0 : currentView.id) === v.id ? 'on' : undefined
    }));
  }, [views, currentView]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "savedViews-loadModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Select a view to load",
    id: "xpack.infra.waffle.savedView.selectViewHeader"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    searchable: true,
    options: options || defaultOptions,
    onChange: onChange,
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.infra.savedView.searchPlaceholder', {
        defaultMessage: 'Search for saved views'
      })
    },
    listProps: {
      bordered: true
    },
    "data-test-subj": "savedViews-loadList"
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), list))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelSavedViewModal",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Cancel",
    id: "xpack.infra.openView.cancelButton"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    "data-test-subj": "loadSavedViewModal",
    onClick: loadView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Load view",
    id: "xpack.infra.openView.loadButton"
  }))));
}