"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedViewsToolbarControls = SavedViewsToolbarControls;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _manage_views_flyout = require("./manage_views_flyout");
var _saved_view = require("../../containers/saved_view/saved_view");
var _view_list_modal = require("./view_list_modal");
var _use_boolean = require("../../hooks/use_boolean");
var _upsert_modal = require("./upsert_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SavedViewsToolbarControls(props) {
  const kibana = (0, _public.useKibana)();
  const {
    views,
    saveView,
    loading,
    updateView,
    deletedId,
    deleteView,
    makeDefault,
    sourceIsLoading,
    find,
    errorOnFind,
    errorOnCreate,
    createdView,
    updatedView,
    currentView,
    setCurrentView
  } = (0, _saved_view.useSavedViewContext)();
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _use_boolean.useBoolean)(false);
  const [isManageFlyoutOpen, {
    on: openManageFlyout,
    off: closeManageFlyout
  }] = (0, _use_boolean.useBoolean)(false);
  const [isUpdateModalOpen, {
    on: openUpdateModal,
    off: closeUpdateModal
  }] = (0, _use_boolean.useBoolean)(false);
  const [isLoadModalOpen, {
    on: openLoadModal,
    off: closeLoadModal
  }] = (0, _use_boolean.useBoolean)(false);
  const [isCreateModalOpen, {
    on: openCreateModal,
    off: closeCreateModal
  }] = (0, _use_boolean.useBoolean)(false);
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  const goToManageViews = () => {
    closePopover();
    find();
    openManageFlyout();
  };
  const goToLoadView = () => {
    closePopover();
    find();
    openLoadModal();
  };
  const goToCreateView = () => {
    closePopover();
    setIsInvalid(false);
    openCreateModal();
  };
  const goToUpdateView = () => {
    closePopover();
    setIsInvalid(false);
    openUpdateModal();
  };
  const save = (0, _react.useCallback)((name, hasTime = false) => {
    const currentState = {
      ...props.viewState,
      ...(!hasTime ? {
        time: undefined
      } : {})
    };
    saveView({
      ...currentState,
      name
    });
  }, [props.viewState, saveView]);
  const update = (0, _react.useCallback)((name, hasTime = false) => {
    const currentState = {
      ...props.viewState,
      ...(!hasTime ? {
        time: undefined
      } : {})
    };
    updateView(currentView.id, {
      ...currentState,
      name
    });
  }, [props.viewState, updateView, currentView]);
  (0, _react.useEffect)(() => {
    if (errorOnCreate) {
      setIsInvalid(true);
    }
  }, [errorOnCreate]);
  (0, _react.useEffect)(() => {
    if (updatedView !== undefined) {
      setCurrentView(updatedView);
      // INFO: Close the modal after the view is created.
      closeUpdateModal();
    }
  }, [updatedView, setCurrentView, closeUpdateModal]);
  (0, _react.useEffect)(() => {
    if (createdView !== undefined) {
      // INFO: Close the modal after the view is created.
      setCurrentView(createdView);
      closeCreateModal();
    }
  }, [createdView, setCurrentView, closeCreateModal]);
  (0, _react.useEffect)(() => {
    if (deletedId !== undefined) {
      // INFO: Refresh view list after an item is deleted
      find();
    }
  }, [deletedId, find]);
  (0, _react.useEffect)(() => {
    if (errorOnCreate) {
      kibana.notifications.toasts.warning(getErrorToast('create', errorOnCreate));
    } else if (errorOnFind) {
      kibana.notifications.toasts.warning(getErrorToast('find', errorOnFind));
    }
  }, [errorOnCreate, errorOnFind, kibana]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "savedViews-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: togglePopover,
      "data-test-subj": "savedViews-openPopover",
      iconType: "arrowDown",
      iconSide: "right",
      color: "text"
    }, currentView ? currentView.name : _i18n.i18n.translate('xpack.infra.savedView.unknownView', {
      defaultMessage: 'No view selected'
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-manageViews",
    iconType: "indexSettings",
    onClick: goToManageViews,
    label: _i18n.i18n.translate('xpack.infra.savedView.manageViews', {
      defaultMessage: 'Manage views'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-updateView",
    iconType: "refresh",
    onClick: goToUpdateView,
    isDisabled: !currentView || currentView.id === '0',
    label: _i18n.i18n.translate('xpack.infra.savedView.updateView', {
      defaultMessage: 'Update view'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-loadView",
    iconType: "importAction",
    onClick: goToLoadView,
    label: _i18n.i18n.translate('xpack.infra.savedView.loadView', {
      defaultMessage: 'Load view'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-saveNewView",
    iconType: "save",
    onClick: goToCreateView,
    label: _i18n.i18n.translate('xpack.infra.savedView.saveNewView', {
      defaultMessage: 'Save new view'
    })
  }))), isCreateModalOpen && /*#__PURE__*/_react.default.createElement(_upsert_modal.UpsertViewModal, {
    isInvalid: isInvalid,
    onClose: closeCreateModal,
    onSave: save,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Save View",
      id: "xpack.infra.waffle.savedView.createHeader"
    })
  }), isUpdateModalOpen && /*#__PURE__*/_react.default.createElement(_upsert_modal.UpsertViewModal, {
    isInvalid: isInvalid,
    onClose: closeUpdateModal,
    onSave: update,
    initialName: currentView.name,
    initialIncludeTime: Boolean(currentView.time),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Update View",
      id: "xpack.infra.waffle.savedView.updateHeader"
    })
  }), isLoadModalOpen && /*#__PURE__*/_react.default.createElement(_view_list_modal.SavedViewListModal, {
    currentView: currentView,
    views: views,
    onClose: closeLoadModal,
    setView: setCurrentView
  }), isManageFlyoutOpen && /*#__PURE__*/_react.default.createElement(_manage_views_flyout.SavedViewManageViewsFlyout, {
    sourceIsLoading: sourceIsLoading,
    loading: loading,
    views: views,
    onMakeDefaultView: makeDefault,
    onDeleteView: deleteView,
    onClose: closeManageFlyout,
    setView: setCurrentView
  }));
}
const getErrorToast = (type, msg) => {
  if (type === 'create') {
    return {
      toastLifeTimeMs: 3000,
      title: msg || _i18n.i18n.translate('xpack.infra.savedView.errorOnCreate.title', {
        defaultMessage: `An error occured saving view.`
      })
    };
  } else if (type === 'find') {
    return {
      toastLifeTimeMs: 3000,
      title: msg || _i18n.i18n.translate('xpack.infra.savedView.findError.title', {
        defaultMessage: `An error occurred while loading views.`
      })
    };
  }
};