"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryContextMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _log_entry_column = require("./log_entry_column");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MENU_LABEL = _i18n.i18n.translate('xpack.infra.logEntryItemView.logEntryActionsMenuToolTip', {
  defaultMessage: 'View actions for line'
});
const LogEntryContextMenu = ({
  'aria-label': ariaLabel,
  isOpen,
  onOpen,
  onClose,
  items,
  externalItems
}) => {
  const closeMenuAndCall = (0, _react.useMemo)(() => {
    return callback => {
      return e => {
        onClose();
        callback === null || callback === void 0 ? void 0 : callback(e);
      };
    };
  }, [onClose]);
  const button = /*#__PURE__*/_react.default.createElement(ButtonWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogEntryContextMenuButton",
    size: "s",
    fill: true,
    "aria-label": ariaLabel || DEFAULT_MENU_LABEL,
    onClick: isOpen ? onClose : onOpen,
    minWidth: "auto"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "boxesHorizontal"
  })));
  const wrappedItems = (0, _react.useMemo)(() => {
    return items.map((item, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: i,
      onClick: closeMenuAndCall(item.onClick),
      href: item.href
    }, item.label)).concat((externalItems !== null && externalItems !== void 0 ? externalItems : []).map((item, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
      key: `external_${i}`
    }, item, {
      onClick: closeMenuAndCall(item.onClick)
    }))));
  }, [items, closeMenuAndCall, externalItems]);
  return /*#__PURE__*/_react.default.createElement(LogEntryContextMenuContent, null, /*#__PURE__*/_react.default.createElement(AbsoluteWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    closePopover: onClose,
    isOpen: isOpen,
    button: button,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: wrappedItems
  }))));
};
exports.LogEntryContextMenu = LogEntryContextMenu;
const LogEntryContextMenuContent = (0, _common.euiStyled)(_log_entry_column.LogEntryColumnContent)`
  overflow: hidden;
  user-select: none;
`;
const AbsoluteWrapper = _common.euiStyled.div`
  position: absolute;
`;
const ButtonWrapper = _common.euiStyled.div`
  transform: translate(-6px, -6px);
`;