"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStreamItemBeforeTimeKey = void 0;
exports.getStreamItemId = getStreamItemId;
exports.getStreamItemTimeKey = getStreamItemTimeKey;
exports.parseStreamItemId = parseStreamItemId;
var _d3Array = require("d3-array");
var _time = require("../../../../common/time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStreamItemTimeKey(item) {
  switch (item.kind) {
    case 'logEntry':
      return item.logEntry.cursor;
  }
}
function getStreamItemId(item) {
  switch (item.kind) {
    case 'logEntry':
      return `${item.logEntry.cursor.time}:${item.logEntry.cursor.tiebreaker}:${item.logEntry.id}`;
  }
}
function parseStreamItemId(id) {
  const idFragments = id.split(':');
  return {
    gid: idFragments.slice(2).join(':'),
    tiebreaker: parseInt(idFragments[1], 10),
    time: parseInt(idFragments[0], 10)
  };
}
const streamItemTimeBisector = (0, _d3Array.bisector)((0, _time.compareToTimeKey)(getStreamItemTimeKey));
const getStreamItemBeforeTimeKey = (streamItems, key) => streamItems[Math.min(streamItemTimeBisector.left(streamItems, key), streamItems.length - 1)];
exports.getStreamItemBeforeTimeKey = getStreamItemBeforeTimeKey;