"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogSearchInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _class;
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const LogSearchInput = (_class = class LogSearchInput extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      query: ''
    });
    (0, _defineProperty2.default)(this, "handleSubmit", evt => {
      evt.preventDefault();
      const {
        query
      } = this.state;
      if (query === '') {
        this.props.onClear();
      } else {
        this.props.onSearch(this.state.query);
      }
    });
    (0, _defineProperty2.default)(this, "handleChangeQuery", evt => {
      this.setState({
        query: evt.target.value
      });
    });
  }
  render() {
    const {
      className,
      isLoading
    } = this.props;
    const {
      query
    } = this.state;
    const classes = (0, _classnames.default)('loggingSearchInput', className);
    return /*#__PURE__*/React.createElement("form", {
      onSubmit: this.handleSubmit
    }, /*#__PURE__*/React.createElement(PlainSearchField, {
      "aria-label": _i18n.i18n.translate('xpack.infra.logs.search.searchInLogsAriaLabel', {
        defaultMessage: 'search'
      }),
      className: classes,
      fullWidth: true,
      isLoading: isLoading,
      onChange: this.handleChangeQuery,
      placeholder: _i18n.i18n.translate('xpack.infra.logs.search.searchInLogsPlaceholder', {
        defaultMessage: 'Search'
      }),
      value: query
    }));
  }
}, (0, _defineProperty2.default)(_class, "displayName", 'LogSearchInput'), _class);
exports.LogSearchInput = LogSearchInput;
const PlainSearchField = (0, _common.euiStyled)(_eui.EuiFieldSearch)`
  background: transparent;
  box-shadow: none;

  &:focus {
    box-shadow: inset 0 -2px 0 0 ${props => props.theme.eui.euiColorPrimary};
  }
`;