"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogSearchControls = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var React = _interopRequireWildcard(require("react"));
var _log_search_buttons = require("./log_search_buttons");
var _log_search_input = require("./log_search_input");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogSearchControls extends React.PureComponent {
  render() {
    const {
      className,
      clearSearch,
      isLoadingSearchResults,
      previousSearchResult,
      nextSearchResult,
      jumpToTarget,
      search
    } = this.props;
    const classes = (0, _classnames.default)('searchControls', className);
    return /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      justifyContent: "flexStart",
      className: classes
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_log_search_input.LogSearchInput, {
      isLoading: isLoadingSearchResults,
      onClear: clearSearch,
      onSearch: search
    })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(_log_search_buttons.LogSearchButtons, {
      previousSearchResult: previousSearchResult,
      nextSearchResult: nextSearchResult,
      jumpToTarget: jumpToTarget
    })));
  }
}
exports.LogSearchControls = LogSearchControls;