"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedInterval = void 0;
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HighlightedInterval = ({
  className,
  end,
  getPositionOfTime,
  start,
  targetWidth,
  width,
  target
}) => {
  const yStart = getPositionOfTime(start);
  const yEnd = getPositionOfTime(end);
  const yTarget = target && getPositionOfTime(target);
  return /*#__PURE__*/React.createElement(React.Fragment, null, yTarget && /*#__PURE__*/React.createElement(HighlightTargetMarker, {
    className: className,
    x1: 0,
    x2: targetWidth,
    y1: yTarget,
    y2: yTarget
  }), /*#__PURE__*/React.createElement(HighlightPolygon, {
    className: className,
    points: ` ${targetWidth},${yStart} ${width},${yStart} ${width},${yEnd}  ${targetWidth},${yEnd}`
  }));
};
exports.HighlightedInterval = HighlightedInterval;
HighlightedInterval.displayName = 'HighlightedInterval';
const HighlightTargetMarker = _common.euiStyled.line`
  stroke: ${props => props.theme.eui.euiColorPrimary};
  stroke-width: 1;
`;
const HighlightPolygon = _common.euiStyled.polygon`
  fill: ${props => props.theme.eui.euiColorPrimary};
  fill-opacity: 0.3;
  stroke: ${props => props.theme.eui.euiColorPrimary};
  stroke-width: 1;
`;