"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogDatepicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogDatepicker = ({
  startDateExpression,
  endDateExpression,
  isStreaming,
  onUpdateDateRange,
  onStartStreaming,
  onStopStreaming
}) => {
  const handleTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (onUpdateDateRange && !isInvalid) {
      onUpdateDateRange({
        startDateExpression: start,
        endDateExpression: end
      });
    }
  }, [onUpdateDateRange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: startDateExpression,
    end: endDateExpression,
    onTimeChange: handleTimeChange,
    showUpdateButton: false
    // @ts-ignore: EuiSuperDatePicker doesn't expose the `isDisabled` prop, although it exists.
    ,
    isDisabled: isStreaming
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isStreaming ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogDatepickerStopStreamingButton",
    color: "primary",
    iconType: "pause",
    iconSide: "left",
    onClick: onStopStreaming
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.stopStreamingButtonLabel",
    defaultMessage: "Stop streaming"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogDatepickerStreamLiveButton",
    color: "primary",
    iconType: "play",
    iconSide: "left",
    onClick: onStartStreaming
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.startStreamingButtonLabel",
    defaultMessage: "Stream live"
  }))));
};
exports.LogDatepicker = LogDatepicker;