"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisModuleList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../containers/logs/log_analysis");
var _log_entry_categories = require("../../../../containers/logs/log_analysis/modules/log_entry_categories");
var _log_entry_rate = require("../../../../containers/logs/log_analysis/modules/log_entry_rate");
var _module_list_card = require("./module_list_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogAnalysisModuleList = ({
  onViewModuleSetup
}) => {
  const {
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis.useLogAnalysisCapabilitiesContext)();
  const {
    setupStatus: logEntryRateSetupStatus,
    jobIds: logEntryRateJobIds
  } = (0, _log_entry_rate.useLogEntryRateModuleContext)();
  const {
    setupStatus: logEntryCategoriesSetupStatus,
    jobIds: logEntryCategoriesJobIds
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const viewLogEntryRateSetupFlyout = (0, _react.useCallback)(() => {
    onViewModuleSetup('logs_ui_analysis');
  }, [onViewModuleSetup]);
  const viewLogEntryCategoriesSetupFlyout = (0, _react.useCallback)(() => {
    onViewModuleSetup('logs_ui_categories');
  }, [onViewModuleSetup]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_module_list_card.LogAnalysisModuleListCard, {
    jobId: logEntryRateJobIds['log-entry-rate'],
    hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
    moduleDescription: _log_entry_rate.logEntryRateModule.moduleDescription,
    moduleName: _log_entry_rate.logEntryRateModule.moduleName,
    moduleStatus: logEntryRateSetupStatus,
    onViewSetup: viewLogEntryRateSetupFlyout
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_module_list_card.LogAnalysisModuleListCard, {
    jobId: logEntryCategoriesJobIds['log-entry-categories-count'],
    hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
    moduleDescription: _log_entry_categories.logEntryCategoriesModule.moduleDescription,
    moduleName: _log_entry_categories.logEntryCategoriesModule.moduleName,
    moduleStatus: logEntryCategoriesSetupStatus,
    onViewSetup: viewLogEntryCategoriesSetupFlyout
  }))));
};
exports.LogAnalysisModuleList = LogAnalysisModuleList;