"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryRateSetupView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _initial_configuration_step = require("../initial_configuration_step");
var _process_step = require("../process_step");
var _log_entry_rate = require("../../../../containers/logs/log_analysis/modules/log_entry_rate");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryRateSetupView = ({
  onClose
}) => {
  const {
    cleanUpAndSetUp,
    endTime,
    isValidating,
    lastSetupErrorMessages,
    moduleDescriptor,
    setEndTime,
    setStartTime,
    setValidatedIndices,
    setUp,
    setupStatus,
    startTime,
    validatedIndices,
    validationErrors,
    viewResults
  } = (0, _log_entry_rate.useLogEntryRateSetup)();
  const viewResultsAndClose = (0, _react.useCallback)(() => {
    viewResults();
    onClose();
  }, [viewResults, onClose]);
  const steps = (0, _react.useMemo)(() => [(0, _initial_configuration_step.createInitialConfigurationStep)({
    setStartTime,
    setEndTime,
    startTime,
    endTime,
    isValidating,
    validatedIndices,
    setupStatus,
    setValidatedIndices,
    validationErrors
  }), (0, _process_step.createProcessStep)({
    cleanUpAndSetUp,
    errorMessages: lastSetupErrorMessages,
    isConfigurationValid: validationErrors.length <= 0 && !isValidating,
    setUp,
    setupStatus,
    viewResults: viewResultsAndClose
  })], [cleanUpAndSetUp, endTime, isValidating, lastSetupErrorMessages, setEndTime, setStartTime, setUp, setValidatedIndices, setupStatus, startTime, validatedIndices, validationErrors, viewResultsAndClose]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, moduleDescriptor.moduleName, " ")), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, moduleDescriptor.moduleDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps
  }));
};
exports.LogEntryRateSetupView = LogEntryRateSetupView;