"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecreateMLJobsButton = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecreateMLJobsButton = ({
  isDisabled,
  onClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.deleteAnalysisResultsWarning",
    defaultMessage: "This removes previously detected anomalies.",
    tagName: "p"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraRecreateMLJobsButtonRecreateMlJobsButton",
    isDisabled: isDisabled,
    fill: true,
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.recreateMlJobButton",
    defaultMessage: "Recreate ML jobs"
  })));
};
exports.RecreateMLJobsButton = RecreateMLJobsButton;