"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySeverityIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _log_analysis = require("../../../../common/log_analysis");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalySeverityIndicator = ({
  anomalyScore
}) => {
  const severityColor = (0, _react.useMemo)(() => getColorForAnomalyScore(anomalyScore), [anomalyScore]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: severityColor
  }, (0, _public.getFormattedSeverityScore)(anomalyScore));
};
exports.AnomalySeverityIndicator = AnomalySeverityIndicator;
const getColorForAnomalyScore = anomalyScore => {
  const severityCategory = (0, _log_analysis.getSeverityCategoryForScore)(anomalyScore);
  if (severityCategory != null && severityCategory in _log_analysis.ML_SEVERITY_COLORS) {
    return _log_analysis.ML_SEVERITY_COLORS[severityCategory];
  } else {
    return 'subdued';
  }
};