"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisJobProblemIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _job_configuration_outdated_callout = require("./job_configuration_outdated_callout");
var _job_definition_outdated_callout = require("./job_definition_outdated_callout");
var _job_stopped_callout = require("./job_stopped_callout");
var _log_analysis_results = require("../log_analysis_results");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogAnalysisJobProblemIndicator = ({
  hasOutdatedJobConfigurations,
  hasOutdatedJobDefinitions,
  hasSetupCapabilities,
  hasStoppedJobs,
  isFirstUse,
  moduleName,
  onRecreateMlJobForReconfiguration,
  onRecreateMlJobForUpdate
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasOutdatedJobDefinitions ? /*#__PURE__*/_react.default.createElement(_job_definition_outdated_callout.JobDefinitionOutdatedCallout, {
    hasSetupCapabilities: hasSetupCapabilities,
    moduleName: moduleName,
    onRecreateMlJob: onRecreateMlJobForUpdate
  }) : null, hasOutdatedJobConfigurations ? /*#__PURE__*/_react.default.createElement(_job_configuration_outdated_callout.JobConfigurationOutdatedCallout, {
    hasSetupCapabilities: hasSetupCapabilities,
    moduleName: moduleName,
    onRecreateMlJob: onRecreateMlJobForReconfiguration
  }) : null, hasStoppedJobs ? /*#__PURE__*/_react.default.createElement(_job_stopped_callout.JobStoppedCallout, null) : null, isFirstUse ? /*#__PURE__*/_react.default.createElement(_log_analysis_results.FirstUseCallout, null) : null);
};
exports.LogAnalysisJobProblemIndicator = LogAnalysisJobProblemIndicator;