"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamEmbeddableFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _log_stream_embeddable = require("./log_stream_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogStreamEmbeddableFactoryDefinition {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _log_stream_embeddable.LOG_STREAM_EMBEDDABLE);
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    const [{
      application
    }] = await this.getStartServices();
    return application.capabilities.logs.save;
  }
  async create(initialInput, parent) {
    const [core, plugins, pluginStart] = await this.getStartServices();
    return new _log_stream_embeddable.LogStreamEmbeddable(core, plugins, pluginStart, initialInput, parent);
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.infra.logStreamEmbeddable.displayName', {
      defaultMessage: 'Log stream'
    });
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.infra.logStreamEmbeddable.description', {
      defaultMessage: 'Add a table of live streaming logs.'
    });
  }
  getIconType() {
    return 'logsApp';
  }
  async getExplicitInput() {
    return {
      title: _i18n.i18n.translate('xpack.infra.logStreamEmbeddable.title', {
        defaultMessage: 'Log stream'
      })
    };
  }
}
exports.LogStreamEmbeddableFactoryDefinition = LogStreamEmbeddableFactoryDefinition;