"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decorateWithKibanaContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _log_views = require("../../../common/http_api/log_views");
var _log_views2 = require("../../../common/log_views");
var _log_entries = require("../../../common/search_strategies/log_entries/log_entries");
var _entries = require("../../test_utils/entries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const decorateWithKibanaContext = (wrappedStory, _storyContext) => {
  const data = {
    dataViews: {
      getFieldsForWildcard: async () => {
        return [];
      }
    },
    search: {
      search: ({
        params
      }, options) => {
        return (0, _rxjs.defer)(() => {
          var _params$after, _params$before;
          switch (options === null || options === void 0 ? void 0 : options.strategy) {
            case _log_entries.LOG_ENTRIES_SEARCH_STRATEGY:
              if (((_params$after = params.after) === null || _params$after === void 0 ? void 0 : _params$after.time) === params.endTimestamp || ((_params$before = params.before) === null || _params$before === void 0 ? void 0 : _params$before.time) === params.startTimestamp) {
                return (0, _rxjs.of)({
                  id: 'MOCK_LOG_ENTRIES_RESPONSE',
                  total: 1,
                  loaded: 1,
                  isRunning: false,
                  isPartial: false,
                  rawResponse: _entries.ENTRIES_EMPTY
                });
              } else {
                const entries = (0, _entries.generateFakeEntries)(200, params.startTimestamp, params.endTimestamp, params.columns || _log_views2.defaultLogViewAttributes.logColumns);
                return (0, _rxjs.of)({
                  id: 'MOCK_LOG_ENTRIES_RESPONSE',
                  total: 1,
                  loaded: 1,
                  isRunning: false,
                  isPartial: false,
                  rawResponse: {
                    data: {
                      entries,
                      topCursor: entries[0].cursor,
                      bottomCursor: entries[entries.length - 1].cursor,
                      hasMoreBefore: false
                    },
                    errors: []
                  }
                });
              }
            case undefined:
            case _common.ES_SEARCH_STRATEGY:
            case _common.ENHANCED_ES_SEARCH_STRATEGY:
              return (0, _rxjs.of)({
                id: 'MOCK_INDEX_CHECK_RESPONSE',
                total: 1,
                loaded: 1,
                isRunning: false,
                isPartial: false,
                rawResponse: {
                  _shards: {
                    failed: 0,
                    successful: 1,
                    total: 1
                  },
                  hits: {
                    hits: [],
                    total: 1
                  },
                  timed_out: false,
                  took: 1
                }
              });
            default:
              return (0, _rxjs.of)({
                id: 'FAKE_RESPONSE',
                rawResponse: {}
              });
          }
        }).pipe((0, _operators.delay)(2000));
      }
    }
  };
  const http = {
    get: async path => {
      switch (path) {
        case '/api/infra/log_views/default':
          return _log_views.getLogViewResponsePayloadRT.encode({
            data: {
              id: 'default',
              origin: 'stored',
              attributes: _log_views2.defaultLogViewAttributes
            }
          });
        default:
          return {};
      }
    }
  };
  const uiSettings = {
    get: setting => {
      switch (setting) {
        case 'dateFormat':
          return 'MMM D, YYYY @ HH:mm:ss.SSS';
        case 'dateFormat:scaled':
          return [['', 'HH:mm:ss.SSS']];
      }
    },
    get$: () => new _rxjs.Subject()
  };
  const overlays = {
    openFlyout: () => {}
  };
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      data,
      http,
      uiSettings,
      overlays
    }
  }, wrappedStory());
};
exports.decorateWithKibanaContext = decorateWithKibanaContext;