"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _common_providers = require("../../../apps/common_providers");
var _metrics_source = require("../../../containers/metrics_source");
var _host_metrics_table = require("./host_metrics_table");
var _use_host_metrics_table = require("./use_host_metrics_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HookedHostMetricsTable({
  timerange,
  filterClauseDsl
}) {
  const hostMetricsTableProps = (0, _use_host_metrics_table.useHostMetricsTable)({
    timerange,
    filterClauseDsl
  });
  return /*#__PURE__*/_react.default.createElement(_host_metrics_table.HostMetricsTable, hostMetricsTableProps);
}
function HostMetricsTableWithProviders({
  timerange,
  filterClauseDsl,
  sourceId,
  ...coreProvidersProps
}) {
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, coreProvidersProps, /*#__PURE__*/_react.default.createElement(_metrics_source.SourceProvider, {
    sourceId: sourceId
  }, /*#__PURE__*/_react.default.createElement(HookedHostMetricsTable, {
    timerange: timerange,
    filterClauseDsl: filterClauseDsl
  })));
}

// Use default export for lazy loading.
// eslint-disable-next-line import/no-default-export
var _default = HostMetricsTableWithProviders;
exports.default = _default;
module.exports = exports.default;