"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSearchErrorCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataSearchErrorCallout = ({
  errors,
  onRetry,
  title
}) => {
  const calloutColor = errors.some(error => error.type !== 'aborted') ? 'danger' : 'warning';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: calloutColor,
    iconType: "warning",
    title: title
  }, errors === null || errors === void 0 ? void 0 : errors.map((error, errorIndex) => /*#__PURE__*/_react.default.createElement(DataSearchErrorMessage, {
    key: errorIndex,
    error: error
  })), onRetry ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraDataSearchErrorCalloutRetryButton",
    color: calloutColor,
    size: "s",
    onClick: onRetry
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.dataSearch.loadingErrorRetryButtonLabel",
    defaultMessage: "Retry"
  })) : null);
};
exports.DataSearchErrorCallout = DataSearchErrorCallout;
const DataSearchErrorMessage = ({
  error
}) => {
  if (error.type === 'aborted') {
    return /*#__PURE__*/_react.default.createElement(AbortedRequestErrorMessage, {
      error: error
    });
  } else if (error.type === 'shardFailure') {
    return /*#__PURE__*/_react.default.createElement(ShardFailureErrorMessage, {
      error: error
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(GenericErrorMessage, {
      error: error
    });
  }
};
const AbortedRequestErrorMessage = ({}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  tagName: "p",
  id: "xpack.infra.dataSearch.abortedRequestErrorMessage",
  defaultMessage: "The request was aborted."
});
const GenericErrorMessage = ({
  error
}) => {
  var _error$message;
  return /*#__PURE__*/_react.default.createElement("p", null, (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : `${error}`);
};
const ShardFailureErrorMessage = ({
  error
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  tagName: "p",
  id: "xpack.infra.dataSearch.shardFailureErrorMessage",
  defaultMessage: "Index {indexName}: {errorMessage}",
  values: {
    indexName: error.shardInfo.index,
    errorMessage: error.message
  }
});