"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.memory = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const memoryLineChart = {
  extraVisualizationState: {
    yLeftExtent: {
      mode: 'custom',
      lowerBound: 0,
      upperBound: 1
    }
  }
};
const memory = {
  title: 'Memory',
  formula: {
    formula: 'average(system.memory.actual.used.pct)',
    format: {
      id: 'percent',
      params: {
        decimals: 0
      }
    }
  },
  lineChartConfig: memoryLineChart,
  getFilters: _utils.getFilters
};
exports.memory = memory;