"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cpuLineChart = exports.cpu = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cpuLineChart = {
  extraVisualizationState: {
    yLeftExtent: {
      mode: 'custom',
      lowerBound: 0,
      upperBound: 1
    }
  }
};
exports.cpuLineChart = cpuLineChart;
const cpu = {
  title: 'CPU Usage',
  formula: {
    formula: '(average(system.cpu.user.pct) + average(system.cpu.system.pct)) / max(system.cpu.cores)',
    format: {
      id: 'percent',
      params: {
        decimals: 0
      }
    }
  },
  getFilters: _utils.getFilters,
  lineChartConfig: cpuLineChart
};
exports.cpu = cpu;