"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationTypes = exports.hostLensFormulas = void 0;
var _host = require("./lens/formulas/host");
var _visualization_types = require("./lens/visualization_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostLensFormulas = {
  cpu: _host.cpu,
  diskIORead: _host.diskIORead,
  diskIOWrite: _host.diskIOWrite,
  hostCount: _host.hostCount,
  load: _host.load,
  memory: _host.memory,
  memoryAvailable: _host.memoryAvailable,
  rx: _host.rx,
  tx: _host.tx
};
exports.hostLensFormulas = hostLensFormulas;
const visualizationTypes = {
  lineChart: _visualization_types.LineChart,
  metricChart: _visualization_types.MetricChart
};
exports.visualizationTypes = visualizationTypes;