"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _xstate = require("xstate");
var _public = require("@kbn/kibana-utils-plugin/public");
var _log_view_state = require("../observability_logs/log_view_state");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = (core, plugins, pluginStart, params) => {
  const {
    discover
  } = plugins;
  const {
    logViews
  } = pluginStart;
  const machine = (0, _log_view_state.createLogViewStateMachine)({
    initialContext: {
      logViewReference: _log_view_state.DEFAULT_LOG_VIEW
    },
    logViews: logViews.client,
    initializeFromUrl: createInitializeFromUrl(core, params)
  });
  const service = (0, _xstate.interpret)(machine).onTransition(state => {
    if (state.matches('checkingStatus') || state.matches('resolvedPersistedLogView') || state.matches('resolvedInlineLogView')) {
      return redirectToDiscover(discover, state.context.resolvedLogView);
    } else if (state.matches('loadingFailed') || state.matches('resolutionFailed') || state.matches('checkingStatusFailed')) {
      return redirectToDiscover(discover);
    }
  }).start();
  return () => {
    // Stop machine interpreter after navigation
    service.stop();
  };
};
exports.renderApp = renderApp;
const redirectToDiscover = (discover, resolvedLogView) => {
  var _discover$locator2;
  const navigationOptions = {
    replace: true
  };
  if (!resolvedLogView) {
    var _discover$locator;
    return (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate({}, navigationOptions);
  }
  const columns = parseColumns(resolvedLogView.columns);
  const dataViewSpec = resolvedLogView.dataViewReference.toSpec();
  return (_discover$locator2 = discover.locator) === null || _discover$locator2 === void 0 ? void 0 : _discover$locator2.navigate({
    columns,
    dataViewId: dataViewSpec.id,
    dataViewSpec
  }, navigationOptions);
};

/**
 * Helpers
 */

const parseColumns = columns => {
  return columns.map(getColumnValue).filter(Boolean);
};
const getColumnValue = column => {
  if ('messageColumn' in column) return _constants.MESSAGE_FIELD;
  if ('timestampColumn' in column) return _constants.TIMESTAMP_FIELD;
  if ('fieldColumn' in column) return column.fieldColumn.field;
  return null;
};
const createInitializeFromUrl = (core, params) => {
  const toastsService = core.notifications.toasts;
  const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
    history: params.history,
    useHash: false,
    useHashQuery: false
  });
  return (0, _log_view_state.initializeFromUrl)({
    toastsService,
    urlStateStorage
  });
};