"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricRowWithCount = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _kuery_bar = require("../../../../pages/metrics/metrics_explorer/components/kuery_bar");
var _metrics = require("../../../../../common/alerting/metrics");
var _metric_row_controls = require("./metric_row_controls");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricRowWithCount = ({
  name,
  agg,
  filter,
  onDelete,
  disableDelete,
  onChange,
  aggregationTypes,
  dataView
}) => {
  const aggOptions = (0, _react.useMemo)(() => Object.values(aggregationTypes).filter(aggType => aggType.value !== _metrics.Aggregators.CUSTOM).map(aggType => ({
    text: aggType.text,
    value: aggType.value
  })), [aggregationTypes]);
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(name);
  }, [name, onDelete]);
  const handleAggChange = (0, _react.useCallback)(el => {
    onChange({
      name,
      filter,
      aggType: el.target.value
    });
  }, [name, filter, onChange]);
  const handleFilterChange = (0, _react.useCallback)(filterString => {
    onChange({
      name,
      filter: filterString,
      aggType: agg
    });
  }, [name, agg, onChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 145
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.aggregationLabel', {
      defaultMessage: 'Aggregation {name}',
      values: {
        name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricRowWithCountSelect",
    compressed: true,
    options: aggOptions,
    value: agg,
    onChange: handleAggChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.filterLabel', {
      defaultMessage: 'KQL Filter {name}',
      values: {
        name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_kuery_bar.MetricsExplorerKueryBar, {
    placeholder: ' ',
    compressed: true,
    derivedIndexPattern: dataView,
    onChange: handleFilterChange,
    onSubmit: handleFilterChange,
    value: filter
  }))), /*#__PURE__*/_react.default.createElement(_metric_row_controls.MetricRowControls, {
    onDelete: handleDelete,
    disableDelete: disableDelete
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }));
};
exports.MetricRowWithCount = MetricRowWithCount;