"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMetricAnomaly = validateMetricAnomaly;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateMetricAnomaly({
  hasInfraMLCapabilities
}) {
  const validationResult = {
    errors: {}
  };
  const errors = {
    hasInfraMLCapabilities: []
  };
  validationResult.errors = errors;
  if (!hasInfraMLCapabilities) {
    errors.hasInfraMLCapabilities.push(_i18n.i18n.translate('xpack.infra.metrics.alertFlyout.error.mlCapabilitiesRequired', {
      defaultMessage: 'Cannot create an anomaly alert when machine learning is disabled.'
    }));
  }
  return validationResult;
}