"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfluencerFilter = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kuery_bar = require("../../../pages/metrics/metrics_explorer/components/kuery_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_TYPING_DEBOUNCE_MS = 500;
const InfluencerFilter = ({
  fieldName,
  fieldValue,
  nodeType,
  onChangeFieldName,
  onChangeFieldValue,
  derivedIndexPattern
}) => {
  const fieldNameOptions = (0, _react.useMemo)(() => nodeType === 'k8s' ? k8sFieldNames : hostFieldNames, [nodeType]);

  // If initial props contain a fieldValue, assume it was passed in from loaded alertParams,
  // and enable the UI element
  const [isEnabled, updateIsEnabled] = (0, _react.useState)(fieldValue ? true : false);
  const [storedFieldValue, updateStoredFieldValue] = (0, _react.useState)(fieldValue);
  (0, _react.useEffect)(() => nodeType === 'k8s' ? onChangeFieldName((0, _lodash.first)(k8sFieldNames).value) : onChangeFieldName((0, _lodash.first)(hostFieldNames).value), [nodeType, onChangeFieldName]);
  const onSelectFieldName = (0, _react.useCallback)(e => onChangeFieldName(e.target.value), [onChangeFieldName]);
  const onUpdateFieldValue = (0, _react.useCallback)(value => {
    updateStoredFieldValue(value);
    onChangeFieldValue(value);
  }, [onChangeFieldValue]);
  const toggleEnabled = (0, _react.useCallback)(() => {
    const nextState = !isEnabled;
    updateIsEnabled(nextState);
    if (!nextState) {
      onChangeFieldValue('');
    } else {
      onChangeFieldValue(storedFieldValue);
    }
  }, [isEnabled, updateIsEnabled, onChangeFieldValue, storedFieldValue]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnUpdateFieldValue = (0, _react.useCallback)((0, _lodash.debounce)(onUpdateFieldValue, FILTER_TYPING_DEBOUNCE_MS), [onUpdateFieldValue]);
  const affixFieldNameToQuery = fn => (expression, cursorPosition, maxSuggestions) => {
    // Add the field name to the front of the passed-in query
    const prefix = `${fieldName}:`;
    // Trim whitespace to prevent AND/OR suggestions
    const modifiedExpression = `${prefix}${expression}`.trim();
    // Move the cursor position forward by the length of the field name
    const modifiedPosition = cursorPosition + prefix.length;
    return fn(modifiedExpression, modifiedPosition, maxSuggestions, suggestions => suggestions.map(s => ({
      ...s,
      // Remove quotes from suggestions
      text: s.text.replace(/\"/g, '').trim(),
      // Offset the returned suggestions' cursor positions so that they can be autocompleted accurately
      start: s.start - prefix.length,
      end: s.end - prefix.length
    }))
    // Removing quotes can lead to an already-selected suggestion still coming up in the autocomplete list,
    // so filter these out
    .filter(s => !expression.startsWith(s.text)));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      label: filterByNodeLabel,
      id: "anomalyAlertFilterByNodeCheckbox",
      onChange: toggleEnabled,
      checked: isEnabled
    }),
    helpText: isEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.anomalyFilterHelpText', {
      defaultMessage: 'Limit the scope of your alert trigger to anomalies influenced by certain node(s).'
    }), /*#__PURE__*/_react.default.createElement("br", null), _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.anomalyFilterHelpTextExample', {
      defaultMessage: 'For example: "my-node-1" or "my-node-*"'
    })) : null,
    fullWidth: true,
    display: "rowCompressed"
  }, isEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraInfluencerFilterSelect",
    id: "selectInfluencerFieldName",
    value: fieldName,
    onChange: onSelectFieldName,
    options: fieldNameOptions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_kuery_bar.MetricsExplorerKueryBar, {
    derivedIndexPattern: derivedIndexPattern,
    onChange: debouncedOnUpdateFieldValue,
    onSubmit: onUpdateFieldValue,
    value: storedFieldValue,
    curryLoadSuggestions: affixFieldNameToQuery,
    placeholder: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.anomalyInfluencerFilterPlaceholder', {
      defaultMessage: 'Everything'
    })
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
};
exports.InfluencerFilter = InfluencerFilter;
const hostFieldNames = [{
  value: 'host.name',
  text: 'host.name'
}];
const k8sFieldNames = [{
  value: 'kubernetes.pod.uid',
  text: 'kubernetes.pod.uid'
}, {
  value: 'kubernetes.node.name',
  text: 'kubernetes.node.name'
}, {
  value: 'kubernetes.namespace',
  text: 'kubernetes.namespace'
}];
const filterByNodeLabel = _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.filterByNodeLabel', {
  defaultMessage: 'Filter by node'
});