"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrefilledAnomalyAlertFlyout = exports.AlertFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _triggers_actions_context = require("../../../utils/triggers_actions_context");
var _metrics = require("../../../../common/alerting/metrics");
var _use_alert_prefill = require("../../use_alert_prefill");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertFlyout = ({
  metric,
  nodeType,
  visible,
  setVisible
}) => {
  const {
    triggersActionsUI
  } = (0, _react.useContext)(_triggers_actions_context.TriggerActionsContext);
  const onCloseFlyout = (0, _react.useCallback)(() => setVisible(false), [setVisible]);
  const AddAlertFlyout = (0, _react.useMemo)(() => triggersActionsUI && triggersActionsUI.getAddRuleFlyout({
    consumer: 'infrastructure',
    onClose: onCloseFlyout,
    canChangeTrigger: false,
    ruleTypeId: _metrics.METRIC_ANOMALY_ALERT_TYPE_ID,
    metadata: {
      metric,
      nodeType
    }
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [triggersActionsUI, visible]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visible && AddAlertFlyout);
};
exports.AlertFlyout = AlertFlyout;
const PrefilledAnomalyAlertFlyout = ({
  onClose
}) => {
  const {
    inventoryPrefill
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  const {
    nodeType,
    metric
  } = inventoryPrefill;
  return /*#__PURE__*/_react.default.createElement(AlertFlyout, {
    metric: metric,
    nodeType: nodeType,
    visible: true,
    setVisible: onClose
  });
};
exports.PrefilledAnomalyAlertFlyout = PrefilledAnomalyAlertFlyout;