"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorsRT = exports.criterionErrorsRT = exports.criterionErrorRT = void 0;
exports.validateExpression = validateExpression;
var _i18n = require("@kbn/i18n");
var rt = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _types = require("../../../common/alerting/logs/log_threshold/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const criterionErrorRT = rt.type({
  field: rt.array(rt.string),
  comparator: rt.array(rt.string),
  value: rt.array(rt.string)
});
exports.criterionErrorRT = criterionErrorRT;
const criterionErrorsRT = rt.record(rt.string, criterionErrorRT);
exports.criterionErrorsRT = criterionErrorsRT;
const alertingErrorRT = rt.recursion('AlertingError', () => rt.record(rt.string, rt.union([rt.string, rt.array(rt.string), alertingErrorRT])));
const errorsRT = rt.type({
  threshold: rt.type({
    value: rt.array(rt.string)
  }),
  // NOTE: The data structure for criteria errors isn't 100%
  // ideal but we need to conform to the interfaces that the alerting
  // framework expects.
  criteria: rt.record(rt.string, criterionErrorsRT),
  timeWindowSize: rt.array(rt.string),
  timeSizeUnit: rt.array(rt.string)
});
exports.errorsRT = errorsRT;
function validateExpression({
  count,
  criteria,
  timeSize
}) {
  const validationResult = {
    errors: {}
  };

  // NOTE: In the case of components provided by the Alerting framework the error property names
  // must match what they expect.
  const errors = {
    threshold: {
      value: []
    },
    criteria: {},
    timeSizeUnit: [],
    timeWindowSize: []
  };
  validationResult.errors = errors;

  // Threshold validation
  if (!(0, _lodash.isNumber)(count === null || count === void 0 ? void 0 : count.value) && !(0, _lodash.isFinite)(count === null || count === void 0 ? void 0 : count.value)) {
    errors.threshold.value.push(_i18n.i18n.translate('xpack.infra.logs.alertFlyout.error.thresholdRequired', {
      defaultMessage: 'Numeric threshold value is Required.'
    }));
  }

  // Time validation
  if (!timeSize) {
    errors.timeWindowSize.push(_i18n.i18n.translate('xpack.infra.logs.alertFlyout.error.timeSizeRequired', {
      defaultMessage: 'Time size is Required.'
    }));
  }

  // Criteria validation
  if (criteria && criteria.length > 0) {
    const getCriterionErrors = _criteria => {
      const _errors = {};
      _criteria.forEach((criterion, idx) => {
        _errors[idx] = {
          field: [],
          comparator: [],
          value: []
        };
        if (!criterion.field) {
          _errors[idx].field.push(_i18n.i18n.translate('xpack.infra.logs.alertFlyout.error.criterionFieldRequired', {
            defaultMessage: 'Field is required.'
          }));
        }
        if (!criterion.comparator) {
          _errors[idx].comparator.push(_i18n.i18n.translate('xpack.infra.logs.alertFlyout.error.criterionComparatorRequired', {
            defaultMessage: 'Comparator is required.'
          }));
        }
        if (criterion.value === undefined || criterion.value === null) {
          _errors[idx].value.push(_i18n.i18n.translate('xpack.infra.logs.alertFlyout.error.criterionValueRequired', {
            defaultMessage: 'Value is required.'
          }));
        }
      });
      return _errors;
    };
    if (!(0, _types.isRatioRule)(criteria)) {
      const criteriaErrors = getCriterionErrors(criteria);
      errors.criteria[0] = criteriaErrors;
    } else {
      const numeratorErrors = getCriterionErrors((0, _types.getNumerator)(criteria));
      errors.criteria[0] = numeratorErrors;
      const denominatorErrors = getCriterionErrors((0, _types.getDenominator)(criteria));
      errors.criteria[1] = denominatorErrors;
    }
  }
  return validationResult;
}