"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatRuleData = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alert_link = require("../../../common/formatters/alert_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatRuleData = ({
  fields
}) => {
  var _fields$ALERT_REASON;
  const reason = (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '';
  const alertStartDate = fields[_ruleDataUtils.ALERT_START];
  const timestamp = alertStartDate != null ? new Date(alertStartDate).valueOf() : null;
  return {
    reason,
    link: (0, _alert_link.getLogsAppAlertUrl)(timestamp) // TODO: refactor to URL generators
  };
};
exports.formatRuleData = formatRuleData;