"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartPreviewData = exports.callGetChartPreviewDataAPI = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _log_threshold = require("../../../../../../common/alerting/logs/log_threshold");
var _use_tracked_promise = require("../../../../../utils/use_tracked_promise");
var _http_api = require("../../../../../../common/http_api");
var _runtime_types = require("../../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useChartPreviewData = ({
  logViewReference,
  ruleParams,
  buckets,
  executionTimeRange,
  filterSeriesByGroupName
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const [chartPreviewData, setChartPreviewData] = (0, _react.useState)([]);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const [getChartPreviewDataRequest, getChartPreviewData] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      setHasError(false);
      if ((0, _log_threshold.isRatioRule)(ruleParams.criteria)) {
        var _ruleParams$groupBy;
        const ratio = await Promise.all([callGetChartPreviewDataAPI(logViewReference, http.fetch, {
          ...ruleParams,
          criteria: [...ruleParams.criteria[0]]
        }, buckets, executionTimeRange), callGetChartPreviewDataAPI(logViewReference, http.fetch, {
          ...ruleParams,
          criteria: [...ruleParams.criteria[1]]
        }, buckets, executionTimeRange)]);
        // The two array have the same length and the same time range.
        let seriesQueryA = ratio[0].data.series[0].points;
        let seriesQueryB = ratio[1].data.series[0].points;
        let seriesId = 'ratio';
        // When groupBy and a filter is applied, return the ratio only for the filtered grouped-by
        if ((_ruleParams$groupBy = ruleParams.groupBy) !== null && _ruleParams$groupBy !== void 0 && _ruleParams$groupBy.length && filterSeriesByGroupName) {
          var _ratio$0$data$series$, _ratio$1$data$series$;
          seriesId = filterSeriesByGroupName;
          seriesQueryA = ((_ratio$0$data$series$ = ratio[0].data.series.find(series => series.id === filterSeriesByGroupName)) === null || _ratio$0$data$series$ === void 0 ? void 0 : _ratio$0$data$series$.points) || [];
          seriesQueryB = ((_ratio$1$data$series$ = ratio[1].data.series.find(series => series.id === filterSeriesByGroupName)) === null || _ratio$1$data$series$ === void 0 ? void 0 : _ratio$1$data$series$.points) || [];
        }
        const ratioPoints = [];
        for (let index = 0; index < seriesQueryA.length; index++) {
          const point = {
            timestamp: seriesQueryA[index].timestamp,
            value: 0
          };
          // We follow the mathematics principle that dividing by 0 isn't possible,
          if (seriesQueryA[index].value === 0 || seriesQueryB[index].value === 0) {
            ratioPoints.push(point);
          } else {
            const ratioValue = seriesQueryA[index].value / seriesQueryB[index].value;
            ratioPoints.push({
              ...point,
              value: ratioValue
            });
          }
        }
        const series = [{
          id: seriesId,
          points: ratioPoints
        }];
        return {
          data: {
            series
          }
        };
      }
      return await callGetChartPreviewDataAPI(logViewReference, http.fetch, ruleParams, buckets, executionTimeRange);
    },
    onResolve: ({
      data: {
        series
      }
    }) => {
      setHasError(false);
      setChartPreviewData(series);
    },
    onReject: error => {
      setHasError(true);
    }
  }, [logViewReference, http, ruleParams, buckets]);
  const isLoading = (0, _react.useMemo)(() => getChartPreviewDataRequest.state === 'pending', [getChartPreviewDataRequest.state]);
  return {
    chartPreviewData,
    hasError,
    isLoading,
    getChartPreviewData
  };
};
exports.useChartPreviewData = useChartPreviewData;
const callGetChartPreviewDataAPI = async (logViewReference, fetch, alertParams, buckets, executionTimeRange) => {
  const response = await fetch(_http_api.LOG_ALERTS_CHART_PREVIEW_DATA_PATH, {
    method: 'POST',
    body: JSON.stringify(_http_api.getLogAlertsChartPreviewDataRequestPayloadRT.encode({
      data: {
        logView: logViewReference,
        alertParams,
        buckets,
        executionTimeRange
      }
    }))
  });
  return (0, _runtime_types.decodeOrThrow)(_http_api.getLogAlertsChartPreviewDataSuccessResponsePayloadRT)(response);
};
exports.callGetChartPreviewDataAPI = callGetChartPreviewDataAPI;