"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _public = require("@kbn/data-plugin/public");
var _lodash = require("lodash");
var _use_kibana = require("../../../../hooks/use_kibana");
var _get_chart_group_names = require("../../../../../common/utils/get_chart_group_names");
var _log_threshold = require("../../../../../common/alerting/logs/log_threshold");
var _criterion_preview_chart = require("../expression_editor/criterion_preview_chart");
var _threshold = require("../../../common/components/threshold");
var _logs_ratio_chart = _interopRequireDefault(require("./components/logs_ratio_chart"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const LogsHistoryChart = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/logs_history_chart'))));
const formatThreshold = threshold => String(threshold);
const AlertDetailsAppSection = ({
  rule,
  alert,
  setAlertSummaryFields
}) => {
  const [selectedSeries, setSelectedSeries] = (0, _react.useState)('');
  const {
    uiSettings
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const theme = (0, _react2.useTheme)();
  const timeRange = (0, _observabilityAlertDetails.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END]);
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).valueOf() : undefined;
  (0, _react.useEffect)(() => {
    var _rule$params$groupBy;
    /**
     * The `CriterionPreview` chart shows all the series/data stacked when there is a GroupBy in the rule parameters.
     * e.g., `host.name`, the chart will show stacks of data by hostname.
     * We only need the chart to show the series that is related to the selected alert.
     * The chart series are built based on the GroupBy in the rule params
     * Each series have an id which is the just a joining of fields value of the GroupBy `getChartGroupNames`
     * We filter down the series using this group name
     */
    const alertFieldsFromGroupBy = ((_rule$params$groupBy = rule.params.groupBy) === null || _rule$params$groupBy === void 0 ? void 0 : _rule$params$groupBy.reduce((selectedFields, field) => ({
      ...selectedFields,
      ...{
        [field]: (0, _lodash.get)(alert.fields[_ruleDataUtils.ALERT_CONTEXT], ['groupByKeys', ...field.split('.')], null)
      }
    }), {})) || {};
    setSelectedSeries((0, _get_chart_group_names.getChartGroupNames)(Object.values(alertFieldsFromGroupBy)));
    const alertSummaryFields = Object.entries(alertFieldsFromGroupBy).map(([label, value]) => ({
      label,
      value
    }));
    setAlertSummaryFields(alertSummaryFields);
  }, [alert.fields, rule.params.groupBy, setAlertSummaryFields]);
  const getLogRatioChart = () => {
    if ((0, _log_threshold.isRatioRule)(rule.params.criteria)) {
      var _alert$fields$ALERT_E;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasBorder: true,
        "data-test-subj": "logsRatioChartAlertDetails"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chart.ratioTitle', {
        defaultMessage: 'Ratio of QUERY A TO QUERY B'
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          maxHeight: 120
        },
        grow: 1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
        title: `Threshold breached`,
        chartProps: {
          theme,
          baseTheme: _charts.LIGHT_THEME
        },
        comparator: _log_threshold.ComparatorToi18nSymbolsMap[rule.params.count.comparator],
        id: 'threshold-ratio-chart',
        threshold: rule.params.count.value,
        value: Number((_alert$fields$ALERT_E = alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE]) === null || _alert$fields$ALERT_E === void 0 ? void 0 : _alert$fields$ALERT_E.toFixed(2)),
        valueFormatter: formatThreshold
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 5
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_logs_ratio_chart.default, {
        buckets: 1,
        logViewReference: {
          type: 'log-view-reference',
          logViewId: rule.params.logView.logViewId
        },
        ruleParams: rule.params,
        filterSeriesByGroupName: selectedSeries,
        showThreshold: true,
        threshold: rule.params.count,
        executionTimeRange: {
          gte: Number((0, _moment.default)(timeRange.from).format('x')),
          lte: Number((0, _moment.default)(timeRange.to).format('x'))
        },
        annotations: [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertAnnotation, {
          key: `${alert.start}-start-alert-annotation`,
          id: `${alert.start}-start-alert-annotation`,
          alertStart: alert.start,
          color: euiTheme.colors.danger,
          dateFormat: uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT)
        }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertActiveTimeRangeAnnotation, {
          key: `${alert.start}-active-alert-annotation`,
          id: `${alert.start}-active-alert-annotation`,
          alertStart: alert.start,
          alertEnd: alertEnd,
          color: euiTheme.colors.danger
        })]
      }))));
    } else return null;
  };
  const getLogCountChart = () => {
    if (!!rule.params.criteria && !(0, _log_threshold.isRatioRule)(rule.params.criteria)) {
      return rule.params.criteria.map((criteria, idx) => {
        const chartCriterion = criteria;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          key: `${chartCriterion.field}${idx}`,
          hasBorder: true,
          "data-test-subj": `logsCountChartAlertDetails-${chartCriterion.field}${idx}`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "none",
          responsive: false
        }, chartCriterion.comparator && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "xs"
        }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.infra.logs.alertDetails.chart.chartTitle', {
          defaultMessage: 'Logs for {field} {comparator} {value}',
          values: {
            field: chartCriterion.field,
            comparator: _log_threshold.ComparatorToi18nMap[chartCriterion.comparator],
            value: chartCriterion.value
          }
        }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "l"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          style: {
            maxHeight: 120
          },
          grow: 1
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "s"
        }), chartCriterion.comparator && /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
          title: `Threshold breached`,
          chartProps: {
            theme,
            baseTheme: _charts.LIGHT_THEME
          },
          comparator: _log_threshold.ComparatorToi18nSymbolsMap[rule.params.count.comparator],
          id: `${chartCriterion.field}-${chartCriterion.value}`,
          threshold: rule.params.count.value,
          value: Number(alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE]),
          valueFormatter: formatThreshold
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: 5
        }, /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.CriterionPreview, {
          ruleParams: rule.params,
          logViewReference: {
            type: 'log-view-reference',
            logViewId: rule.params.logView.logViewId
          },
          chartCriterion: chartCriterion,
          showThreshold: true,
          executionTimeRange: {
            gte: Number((0, _moment.default)(timeRange.from).format('x')),
            lte: Number((0, _moment.default)(timeRange.to).format('x'))
          },
          annotations: [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertAnnotation, {
            key: `${alert.start}${chartCriterion.field}${idx}-start-alert-annotation`,
            id: `${alert.start}${chartCriterion.field}${idx}-start-alert-annotation`,
            alertStart: alert.start,
            color: euiTheme.colors.danger,
            dateFormat: uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT)
          }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertActiveTimeRangeAnnotation, {
            key: `${alert.start}${chartCriterion.field}${idx}-active-alert-annotation`,
            id: `${alert.start}${chartCriterion.field}${idx}-active-alert-annotation`,
            alertStart: alert.start,
            alertEnd: alertEnd,
            color: euiTheme.colors.danger
          })],
          filterSeriesByGroupName: [selectedSeries]
        }))));
      });
    } else return null;
  };
  const getLogsHistoryChart = () => {
    return rule && rule.params.criteria.length === 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(LogsHistoryChart, {
      rule: {
        ...rule,
        params: {
          ...rule.params,
          timeSize: 12,
          timeUnit: 'h'
        }
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "logsThresholdAlertDetailsPage"
  }, getLogRatioChart(), getLogCountChart(), getLogsHistoryChart());
};
// eslint-disable-next-line import/no-default-export
var _default = AlertDetailsAppSection;
exports.default = _default;
module.exports = exports.default;