"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _charts = require("@elastic/charts");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _runtime_types = require("../../../../../../common/runtime_types");
var _http_api = require("../../../../../../common/http_api");
var _log_threshold = require("../../../../../../common/alerting/logs/log_threshold");
var _use_kibana_time_zone_setting = require("../../../../../hooks/use_kibana_time_zone_setting");
var _get_chart_theme = require("../../../../../utils/get_chart_theme");
var _criterion_preview_chart = require("../../../../common/criterion_preview_chart/criterion_preview_chart");
var _color_palette = require("../../../../../../common/color_palette");
var _use_chart_preview_data = require("../../expression_editor/hooks/use_chart_preview_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsRatioChart = ({
  buckets,
  ruleParams,
  logViewReference,
  threshold,
  showThreshold,
  executionTimeRange,
  filterSeriesByGroupName,
  annotations
}) => {
  const chartAlertParams = (0, _react.useMemo)(() => {
    const params = {
      criteria: ruleParams.criteria,
      count: {
        comparator: ruleParams.count.comparator,
        value: ruleParams.count.value
      },
      timeSize: ruleParams.timeSize,
      timeUnit: ruleParams.timeUnit,
      groupBy: ruleParams.groupBy
    };
    try {
      return (0, _runtime_types.decodeOrThrow)(_http_api.getLogAlertsChartPreviewDataAlertParamsSubsetRT)(params);
    } catch (error) {
      return null;
    }
  }, [ruleParams.criteria, ruleParams.count.comparator, ruleParams.count.value, ruleParams.timeSize, ruleParams.timeUnit, ruleParams.groupBy]);
  const {
    getChartPreviewData,
    isLoading,
    hasError,
    chartPreviewData: series
  } = (0, _use_chart_preview_data.useChartPreviewData)({
    logViewReference,
    ruleParams: chartAlertParams,
    buckets,
    executionTimeRange,
    filterSeriesByGroupName
  });
  (0, _react.useEffect)(() => {
    getChartPreviewData();
  }, [getChartPreviewData]);
  const {
    uiSettings
  } = (0, _public.useKibana)().services;
  const isDarkMode = (uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('theme:darkMode')) || false;
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const {
    yMin,
    yMax,
    xMin,
    xMax
  } = (0, _criterion_preview_chart.getDomain)(series, false);
  const dateFormatter = (0, _criterion_preview_chart.useDateFormatter)(xMin, xMax);
  const hasData = series.length > 0;
  const THRESHOLD_OPACITY = 0.3;
  const chartDomain = {
    max: showThreshold && threshold ? Math.max(yMax, threshold.value) * 1.1 : yMax * 1.1,
    // Add 10% headroom.
    min: showThreshold && threshold ? Math.min(yMin, threshold.value) : yMin
  };
  const isAbove = showThreshold && threshold && threshold.comparator ? [_log_threshold.Comparator.GT, _log_threshold.Comparator.GT_OR_EQ].includes(threshold.comparator) : false;
  const isBelow = showThreshold && threshold && threshold.comparator ? [_log_threshold.Comparator.LT, _log_threshold.Comparator.LT_OR_EQ].includes(threshold.comparator) : false;
  const barSeries = (0, _react.useMemo)(() => {
    return series.flatMap(({
      points,
      id
    }) => points.map(point => ({
      ...point,
      groupBy: id
    })));
  }, [series]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.LoadingState, null);
  } else if (hasError) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.ErrorState, null);
  } else if (!hasData) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.NoDataState, null);
  }
  return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.ChartContainer, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "criterion-preview",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: ['value'],
    splitSeriesAccessors: ['groupBy'],
    data: barSeries,
    barSeriesStyle: {
      rectBorder: {
        stroke: (0, _color_palette.colorTransformer)(_color_palette.Color.color0),
        strokeWidth: 1,
        visible: true
      },
      rect: {
        opacity: 1
      }
    },
    color: (0, _color_palette.colorTransformer)(_color_palette.Color.color0),
    timeZone: timezone
  }), showThreshold && threshold ? /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: `threshold-line`,
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: threshold.value
    }],
    style: {
      line: {
        strokeWidth: 2,
        stroke: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
        opacity: 1
      }
    }
  }) : null, showThreshold && threshold && isBelow ? /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: "below-threshold",
    style: {
      fill: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
      opacity: THRESHOLD_OPACITY
    },
    dataValues: [{
      coordinates: {
        x0: xMin,
        x1: xMax,
        y0: chartDomain.min,
        y1: threshold.value
      }
    }]
  }) : null, annotations, showThreshold && threshold && isAbove ? /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: "above-threshold",
    style: {
      fill: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
      opacity: THRESHOLD_OPACITY
    },
    dataValues: [{
      coordinates: {
        x0: xMin,
        x1: xMax,
        y0: threshold.value,
        y1: chartDomain.max
      }
    }]
  }) : null, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: _criterion_preview_chart.yAxisFormatter,
    domain: chartDomain
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    tooltip: _criterion_preview_chart.tooltipProps,
    theme: (0, _get_chart_theme.getChartTheme)(isDarkMode)
  })));
};
// eslint-disable-next-line import/no-default-export
var _default = LogsRatioChart;
exports.default = _default;
module.exports = exports.default;