"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionChart = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _color_palette = require("../../../../common/color_palette");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_snaphot = require("../../../pages/metrics/inventory_view/hooks/use_snaphot");
var _use_waffle_options = require("../../../pages/metrics/inventory_view/hooks/use_waffle_options");
var _create_inventory_metric_formatter = require("../../../pages/metrics/inventory_view/lib/create_inventory_metric_formatter");
var _calculate_domain = require("../../../pages/metrics/metrics_explorer/components/helpers/calculate_domain");
var _get_metric_id = require("../../../pages/metrics/metrics_explorer/components/helpers/get_metric_id");
var _series_chart = require("../../../pages/metrics/metrics_explorer/components/series_chart");
var _use_metrics_explorer_options = require("../../../pages/metrics/metrics_explorer/hooks/use_metrics_explorer_options");
var _criterion_preview_chart = require("../../common/criterion_preview_chart/criterion_preview_chart");
var _threshold_annotations = require("../../common/criterion_preview_chart/threshold_annotations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpressionChart = ({
  expression,
  filterQuery,
  nodeType,
  sourceId
}) => {
  var _expression$warningTh, _expression$warningTh2, _nodes$2, _nodes$2$metrics$, _nodes$3;
  const timerange = (0, _react.useMemo)(() => ({
    interval: `${expression.timeSize || 1}${expression.timeUnit}`,
    from: (0, _moment.default)().subtract((expression.timeSize || 1) * 20, expression.timeUnit).valueOf(),
    to: (0, _moment.default)().valueOf(),
    forceInterval: true
  }), [expression.timeSize, expression.timeUnit]);
  const buildCustomMetric = metric => ({
    ...metric,
    type: 'custom'
  });
  const options = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    loading,
    nodes
  } = (0, _use_snaphot.useSnapshot)({
    filterQuery,
    metrics: expression.metric === 'custom' ? [buildCustomMetric(expression.customMetric)] : [{
      type: expression.metric
    }],
    groupBy: [],
    nodeType,
    sourceId,
    currentTime: 0,
    accountId: options.accountId,
    region: options.region,
    timerange
  });
  const {
    uiSettings
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const metric = {
    field: expression.metric,
    aggregation: 'avg',
    color: _color_palette.Color.color0
  };
  const isDarkMode = (uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('theme:darkMode')) || false;
  const dateFormatter = (0, _react.useMemo)(() => {
    var _nodes$, _nodes$$metrics$, _first, _last;
    const firstSeries = (_nodes$ = nodes[0]) === null || _nodes$ === void 0 ? void 0 : (_nodes$$metrics$ = _nodes$.metrics[0]) === null || _nodes$$metrics$ === void 0 ? void 0 : _nodes$$metrics$.timeseries;
    const firstTimestamp = (_first = (0, _lodash.first)(firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.rows)) === null || _first === void 0 ? void 0 : _first.timestamp;
    const lastTimestamp = (_last = (0, _lodash.last)(firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.rows)) === null || _last === void 0 ? void 0 : _last.timestamp;
    if (firstTimestamp == null || lastTimestamp == null) {
      return value => `${value}`;
    }
    return (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  }, [nodes]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const yAxisFormater = (0, _react.useCallback)((0, _create_inventory_metric_formatter.createInventoryMetricFormatter)(expression.metric === 'custom' ? buildCustomMetric(expression.customMetric) : {
    type: expression.metric
  }), [expression.metric]);
  if (loading || !nodes) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.LoadingState, null);
  }
  const convertThreshold = threshold => convertMetricValue(expression.metric, threshold);
  const convertedThresholds = expression.threshold.map(convertThreshold);
  const convertedWarningThresholds = (_expression$warningTh = (_expression$warningTh2 = expression.warningThreshold) === null || _expression$warningTh2 === void 0 ? void 0 : _expression$warningTh2.map(convertThreshold)) !== null && _expression$warningTh !== void 0 ? _expression$warningTh : [];
  const criticalThresholds = convertedThresholds.slice().sort();
  const warningThresholds = convertedWarningThresholds.slice().sort();
  const thresholds = [...criticalThresholds, ...warningThresholds].sort();

  // Creating a custom series where the ID is changed to 0
  // so that we can get a proper domian
  const firstSeries = (_nodes$2 = nodes[0]) === null || _nodes$2 === void 0 ? void 0 : (_nodes$2$metrics$ = _nodes$2.metrics[0]) === null || _nodes$2$metrics$ === void 0 ? void 0 : _nodes$2$metrics$.timeseries;
  if (!firstSeries || !firstSeries.rows || firstSeries.rows.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.NoDataState, null);
  }
  const series = {
    ...firstSeries,
    id: (_nodes$3 = nodes[0]) === null || _nodes$3 === void 0 ? void 0 : _nodes$3.name,
    rows: firstSeries.rows.map(row => {
      const newRow = {
        ...row
      };
      thresholds.forEach((thresholdValue, index) => {
        newRow[(0, _get_metric_id.getMetricId)(metric, `threshold_${index}`)] = thresholdValue;
      });
      return newRow;
    })
  };
  const firstTimestamp = (0, _lodash.first)(firstSeries.rows).timestamp;
  const lastTimestamp = (0, _lodash.last)(firstSeries.rows).timestamp;
  const dataDomain = (0, _calculate_domain.calculateDomain)(series, [metric], false);
  const domain = {
    max: Math.max(dataDomain.max, (0, _lodash.last)(thresholds) || dataDomain.max) * 1.1,
    // add 10% headroom.
    min: Math.min(dataDomain.min, (0, _lodash.first)(thresholds) || dataDomain.min) * 0.9 // add 10% floor
  };

  if (domain.min === (0, _lodash.first)(convertedThresholds)) {
    domain.min = domain.min * 0.9;
  }
  const {
    timeSize,
    timeUnit
  } = expression;
  const timeLabel = _criterion_preview_chart.TIME_LABELS[timeUnit];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.ChartContainer, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_series_chart.MetricExplorerSeriesChart, {
    type: _use_metrics_explorer_options.MetricsExplorerChartType.bar,
    metric: metric,
    id: "0",
    series: series,
    stack: false
  }), /*#__PURE__*/_react.default.createElement(_threshold_annotations.ThresholdAnnotations, {
    comparator: expression.comparator,
    threshold: convertedThresholds,
    sortedThresholds: criticalThresholds,
    color: _color_palette.Color.color1,
    id: "critical",
    firstTimestamp: firstTimestamp,
    lastTimestamp: lastTimestamp,
    domain: domain
  }), expression.warningComparator && expression.warningThreshold && /*#__PURE__*/_react.default.createElement(_threshold_annotations.ThresholdAnnotations, {
    comparator: expression.warningComparator,
    threshold: convertedWarningThresholds,
    sortedThresholds: warningThresholds,
    color: _color_palette.Color.color5,
    id: "warning",
    firstTimestamp: firstTimestamp,
    lastTimestamp: lastTimestamp,
    domain: domain
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'timestamp',
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: 'values',
    position: _charts.Position.Left,
    tickFormat: yAxisFormater,
    domain: domain
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    tooltip: _criterion_preview_chart.tooltipProps,
    theme: (0, _criterion_preview_chart.getChartTheme)(isDarkMode)
  }))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, series.id !== 'ALL' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alerts.dataTimeRangeLabelWithGrouping",
    defaultMessage: "Last {lookback} {timeLabel} of data for {id}",
    values: {
      id: series.id,
      timeLabel,
      lookback: timeSize * 20
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alerts.dataTimeRangeLabel",
    defaultMessage: "Last {lookback} {timeLabel}",
    values: {
      timeLabel,
      lookback: timeSize * 20
    }
  }))));
};
exports.ExpressionChart = ExpressionChart;
const convertMetricValue = (metric, value) => {
  if (converters[metric]) {
    return converters[metric](value);
  } else {
    return value;
  }
};
const converters = {
  cpu: n => Number(n) / 100,
  memory: n => Number(n) / 100
};