"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Threshold = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Threshold = ({
  chartProps: {
    theme,
    baseTheme
  },
  comparator,
  id,
  threshold,
  title,
  value,
  valueFormatter
}) => {
  const color = (0, _eui.useEuiBackgroundColor)('danger');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    style: {
      height: '100%',
      overflow: 'hidden',
      position: 'relative',
      minWidth: '100%'
    },
    hasShadow: false,
    "data-test-subj": `threshold-${threshold}-${value}`
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    baseTheme: baseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: id,
    data: [[{
      title,
      extra: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.infra.alerting.thresholdExtraTitle', {
        values: {
          comparator,
          threshold: valueFormatter(threshold)
        },
        defaultMessage: `Alert when {comparator} {threshold}`
      })),
      color,
      value,
      valueFormatter,
      icon: ({
        width,
        height,
        color: iconColor
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        width: width,
        height: height,
        color: iconColor,
        type: "alert"
      })
    }]]
  })));
};
exports.Threshold = Threshold;