"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticMetricsExplorerViewId = exports.staticMetricsExplorerViewAttributes = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const staticMetricsExplorerViewId = '0';
exports.staticMetricsExplorerViewId = staticMetricsExplorerViewId;
const staticMetricsExplorerViewAttributes = {
  name: _i18n.i18n.translate('xpack.infra.savedView.defaultViewNameHosts', {
    defaultMessage: 'Default view'
  }),
  isDefault: false,
  isStatic: true,
  options: {
    aggregation: 'avg',
    metrics: [{
      aggregation: 'avg',
      field: 'system.cpu.total.norm.pct',
      color: 'color0'
    }, {
      aggregation: 'avg',
      field: 'kubernetes.pod.cpu.usage.node.pct',
      color: 'color1'
    }, {
      aggregation: 'avg',
      field: 'docker.cpu.total.pct',
      color: 'color2'
    }],
    source: 'default'
  },
  chartOptions: {
    type: 'line',
    yAxisMode: 'fromZero',
    stack: false
  },
  currentTimerange: {
    from: 'now-1h',
    to: 'now',
    interval: '>=10s'
  }
};
exports.staticMetricsExplorerViewAttributes = staticMetricsExplorerViewAttributes;