"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexMgmtUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _semver = _interopRequireDefault(require("semver/classes/semver"));
var _extension_service = require("./application/store/selectors/extension_service");
var _services = require("./services");
var _plugin = require("../common/constants/plugin");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class IndexMgmtUIPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "extensionsService", new _services.ExtensionsService());
    this.ctx = ctx;
    // Temporary hack to provide the service instances in module files in order to avoid a big refactor
    // For the selectors we should expose them through app dependencies and read them from there on each container component.
    (0, _extension_service.setExtensionsService)(this.extensionsService);
  }
  setup(coreSetup, plugins) {
    const {
      ui: {
        enabled: isIndexManagementUiEnabled
      }
    } = this.ctx.config.get();
    if (isIndexManagementUiEnabled) {
      const {
        fleet,
        usageCollection,
        management
      } = plugins;
      const kibanaVersion = new _semver.default(this.ctx.env.packageInfo.version);
      management.sections.section.data.registerApp({
        id: _plugin.PLUGIN.id,
        title: _i18n.i18n.translate('xpack.idxMgmt.appTitle', {
          defaultMessage: 'Index Management'
        }),
        order: 0,
        mount: async params => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
          return mountManagementSection(coreSetup, usageCollection, params, this.extensionsService, Boolean(fleet), kibanaVersion);
        }
      });
    }
    return {
      extensionsService: this.extensionsService.setup()
    };
  }
  start() {}
  stop() {}
}
exports.IndexMgmtUIPlugin = IndexMgmtUIPlugin;