"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexManagementStore = indexManagementStore;
var _redux = require("redux");
var _reduxThunk = _interopRequireDefault(require("redux-thunk"));
var _table_state = require("./reducers/table_state");
var _reducers = require("./reducers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function indexManagementStore(services) {
  const toggleNameToVisibleMap = {};
  services.extensionsService.toggles.forEach(toggleExtension => {
    toggleNameToVisibleMap[toggleExtension.name] = false;
  });
  const initialState = {
    tableState: {
      ..._table_state.defaultTableState,
      toggleNameToVisibleMap
    }
  };
  const enhancers = [(0, _redux.applyMiddleware)(_reduxThunk.default)];
  window.__REDUX_DEVTOOLS_EXTENSION__ && enhancers.push(window.__REDUX_DEVTOOLS_EXTENSION__());
  return (0, _redux.createStore)((0, _reducers.getReducer)(services), initialState, (0, _redux.compose)(...enhancers));
}