"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortTable = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unitMagnitude = {
  kb: 1,
  mb: 2,
  gb: 3,
  tb: 4,
  pb: 5
};
const stringSort = fieldName => item => {
  return item[fieldName];
};
const numericSort = fieldName => item => +item[fieldName];
const byteSort = fieldName => item => {
  const rawValue = item[fieldName];
  // raw value can be missing if index is closed
  if (!rawValue) {
    return 0;
  }
  const matchResult = rawValue.match(/(.*)([kmgtp]b)/);
  if (!matchResult) {
    return 0;
  }
  const [, number, unit] = matchResult;
  return +number * Math.pow(1024, unitMagnitude[unit]);
};
const sorters = {
  name: stringSort('name'),
  status: stringSort('status'),
  health: stringSort('health'),
  primary: numericSort('primary'),
  replica: numericSort('replica'),
  documents: numericSort('documents'),
  size: byteSort('size'),
  primary_size: byteSort('primary_size'),
  data_stream: stringSort('data_stream')
};
const sortTable = (array = [], sortField, isSortAscending) => {
  const sorted = (0, _lodash.sortBy)(array, sorters[sortField]);
  return isSortAscending ? sorted : sorted.reverse();
};
exports.sortTable = sortTable;