"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.breadcrumbService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BreadcrumbService {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbs", {
      home: []
    });
    (0, _defineProperty2.default)(this, "setBreadcrumbsHandler", void 0);
  }
  setup(setBreadcrumbsHandler) {
    this.setBreadcrumbsHandler = setBreadcrumbsHandler;
    this.breadcrumbs.home = [{
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.homeLabel', {
        defaultMessage: 'Index Management'
      }),
      href: `/`
    }];
    this.breadcrumbs.templates = [...this.breadcrumbs.home, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.templatesLabel', {
        defaultMessage: 'Templates'
      }),
      href: `/templates`
    }];
    this.breadcrumbs.templateCreate = [...this.breadcrumbs.templates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.createTemplateLabel', {
        defaultMessage: 'Create template'
      })
    }];
    this.breadcrumbs.templateEdit = [...this.breadcrumbs.templates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.editTemplateLabel', {
        defaultMessage: 'Edit template'
      })
    }];
    this.breadcrumbs.templateClone = [...this.breadcrumbs.templates, {
      text: _i18n.i18n.translate('xpack.idxMgmt.breadcrumb.cloneTemplateLabel', {
        defaultMessage: 'Clone template'
      })
    }];
  }
  setBreadcrumbs(type) {
    if (!this.setBreadcrumbsHandler) {
      throw new Error(`BreadcrumbService#setup() must be called first!`);
    }
    const newBreadcrumbs = this.breadcrumbs[type] ? [...this.breadcrumbs[type]] : [...this.breadcrumbs.home];

    // Pop off last breadcrumb
    const lastBreadcrumb = newBreadcrumbs.pop();

    // Put last breadcrumb back without href
    newBreadcrumbs.push({
      ...lastBreadcrumb,
      href: undefined
    });
    this.setBreadcrumbsHandler(newBreadcrumbs);
  }
}
const breadcrumbService = new BreadcrumbService();
exports.breadcrumbService = breadcrumbService;